/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import ai.timefold.solver.core.impl.phase.event.PhaseLifecycleListener;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;

public final class SelectionCacheLifecycleBridge<Solution_>
implements PhaseLifecycleListener<Solution_> {
    private final SelectionCacheType cacheType;
    private final SelectionCacheLifecycleListener<Solution_> selectionCacheLifecycleListener;
    private boolean isConstructed = false;

    public SelectionCacheLifecycleBridge(SelectionCacheType cacheType, SelectionCacheLifecycleListener<Solution_> selectionCacheLifecycleListener) {
        this.cacheType = cacheType;
        this.selectionCacheLifecycleListener = selectionCacheLifecycleListener;
        if (cacheType == null) {
            throw new IllegalArgumentException("The cacheType (" + cacheType + ") for selectionCacheLifecycleListener (" + selectionCacheLifecycleListener + ") should have already been resolved.");
        }
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        this.assertNotConstructed();
        if (this.cacheType == SelectionCacheType.SOLVER) {
            this.selectionCacheLifecycleListener.constructCache(solverScope);
            this.isConstructed = true;
        }
    }

    private void assertNotConstructed() {
        if (this.isConstructed) {
            throw new IllegalStateException("Impossible state: selection cache of type (" + this.cacheType + ") for listener (" + this.selectionCacheLifecycleListener + ") already constructed.");
        }
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        if (this.cacheType == SelectionCacheType.PHASE) {
            this.assertNotConstructed();
            this.selectionCacheLifecycleListener.constructCache(phaseScope.getSolverScope());
            this.isConstructed = true;
        }
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        if (this.cacheType == SelectionCacheType.STEP) {
            this.assertNotConstructed();
            this.selectionCacheLifecycleListener.constructCache(stepScope.getPhaseScope().getSolverScope());
            this.isConstructed = true;
        }
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        if (this.cacheType == SelectionCacheType.STEP) {
            this.assertConstructed();
            this.selectionCacheLifecycleListener.disposeCache(stepScope.getPhaseScope().getSolverScope());
            this.isConstructed = false;
        }
    }

    private void assertConstructed() {
        if (!this.isConstructed) {
            throw new IllegalStateException("Impossible state: selection cache of type (" + this.cacheType + ") for listener (" + this.selectionCacheLifecycleListener + ") already disposed of.");
        }
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        if (this.cacheType != SelectionCacheType.SOLVER) {
            if (this.cacheType != SelectionCacheType.STEP) {
                this.assertConstructed();
            }
            this.selectionCacheLifecycleListener.disposeCache(phaseScope.getSolverScope());
            this.isConstructed = false;
        }
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        if (this.cacheType == SelectionCacheType.SOLVER) {
            this.assertConstructed();
            this.selectionCacheLifecycleListener.disposeCache(solverScope);
            this.isConstructed = false;
        } else {
            this.assertNotConstructed();
        }
    }

    public String toString() {
        return "Bridge(" + this.selectionCacheLifecycleListener + ")";
    }
}

