/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public final class FromSolutionEntitySelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements EntitySelector<Solution_> {
    private final EntityDescriptor<Solution_> entityDescriptor;
    private final SelectionCacheType minimumCacheType;
    private final boolean randomSelection;
    private List<Object> cachedEntityList = null;
    private Long cachedEntityListRevision = null;
    private boolean cachedEntityListIsDirty = false;

    public FromSolutionEntitySelector(EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        this.entityDescriptor = entityDescriptor;
        this.minimumCacheType = minimumCacheType;
        this.randomSelection = randomSelection;
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public SelectionCacheType getCacheType() {
        SelectionCacheType intrinsicCacheType = SelectionCacheType.STEP;
        return intrinsicCacheType.compareTo(this.minimumCacheType) > 0 ? intrinsicCacheType : this.minimumCacheType;
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        this.reloadCachedEntityList(scoreDirector);
    }

    private void reloadCachedEntityList(InnerScoreDirector<Solution_, ?> scoreDirector) {
        this.cachedEntityList = this.entityDescriptor.extractEntities(scoreDirector.getWorkingSolution());
        this.cachedEntityListRevision = scoreDirector.getWorkingEntityListRevision();
        this.cachedEntityListIsDirty = false;
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        if (scoreDirector.isWorkingEntityListDirty(this.cachedEntityListRevision)) {
            if (this.minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
                this.cachedEntityListIsDirty = true;
            } else {
                this.reloadCachedEntityList(scoreDirector);
            }
        }
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.cachedEntityList = null;
        this.cachedEntityListRevision = null;
        this.cachedEntityListIsDirty = false;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.cachedEntityList.size();
    }

    @Override
    public Iterator<Object> iterator() {
        this.checkCachedEntityListIsDirty();
        if (!this.randomSelection) {
            return this.cachedEntityList.iterator();
        }
        return new CachedListRandomIterator<Object>(this.cachedEntityList, this.workingRandom);
    }

    @Override
    public ListIterator<Object> listIterator() {
        this.checkCachedEntityListIsDirty();
        if (!this.randomSelection) {
            return this.cachedEntityList.listIterator();
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        this.checkCachedEntityListIsDirty();
        if (!this.randomSelection) {
            return this.cachedEntityList.listIterator(index);
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public Iterator<Object> endingIterator() {
        this.checkCachedEntityListIsDirty();
        return this.cachedEntityList.iterator();
    }

    private void checkCachedEntityListIsDirty() {
        if (this.cachedEntityListIsDirty) {
            throw new IllegalStateException("The selector (" + this + ") with minimumCacheType (" + this.minimumCacheType + ")'s workingEntityList became dirty between steps but is still used afterwards.");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FromSolutionEntitySelector that = (FromSolutionEntitySelector)other;
        return this.randomSelection == that.randomSelection && Objects.equals(this.entityDescriptor, that.entityDescriptor) && this.minimumCacheType == that.minimumCacheType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.entityDescriptor, this.minimumCacheType, this.randomSelection});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entityDescriptor.getEntityClass().getSimpleName() + ")";
    }
}

