/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity.pillar;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.pillar.PillarSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.pillar.SubPillarConfigPolicy;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.SubPillarType;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.entity.pillar.DefaultPillarSelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import ai.timefold.solver.core.impl.solver.ClassInstanceCache;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class PillarSelectorFactory<Solution_>
extends AbstractSelectorFactory<Solution_, PillarSelectorConfig> {
    public static <Solution_> PillarSelectorFactory<Solution_> create(PillarSelectorConfig pillarSelectorConfig) {
        return new PillarSelectorFactory<Solution_>(pillarSelectorConfig);
    }

    public PillarSelectorFactory(PillarSelectorConfig pillarSelectorConfig) {
        super(pillarSelectorConfig);
    }

    public PillarSelector<Solution_> buildPillarSelector(HeuristicConfigPolicy<Solution_> configPolicy, SubPillarType subPillarType, Class<? extends Comparator<Object>> subPillarSequenceComparatorClass, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder, List<String> variableNameIncludeList) {
        if (subPillarType != SubPillarType.SEQUENCE && subPillarSequenceComparatorClass != null) {
            throw new IllegalArgumentException("Subpillar type (" + subPillarType + ") on pillarSelectorConfig (" + this.config + ") is not " + SubPillarType.SEQUENCE + ", yet subPillarSequenceComparatorClass (" + subPillarSequenceComparatorClass + ") is provided.");
        }
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
            throw new IllegalArgumentException("The pillarSelectorConfig (" + this.config + ")'s minimumCacheType (" + minimumCacheType + ") must not be higher than " + SelectionCacheType.STEP + " because the pillars change every step.");
        }
        boolean subPillarEnabled = subPillarType != SubPillarType.NONE;
        EntitySelectorConfig entitySelectorConfig = Objects.requireNonNullElseGet(((PillarSelectorConfig)this.config).getEntitySelectorConfig(), EntitySelectorConfig::new);
        EntitySelector entitySelector = EntitySelectorFactory.create(entitySelectorConfig).buildEntitySelector(configPolicy, minimumCacheType, SelectionOrder.ORIGINAL);
        List variableDescriptors = this.deduceVariableDescriptorList(entitySelector.getEntityDescriptor(), variableNameIncludeList);
        if (!(subPillarEnabled || ((PillarSelectorConfig)this.config).getMinimumSubPillarSize() == null && ((PillarSelectorConfig)this.config).getMaximumSubPillarSize() == null)) {
            throw new IllegalArgumentException("The pillarSelectorConfig (" + this.config + ") must not disable subpillars while providing minimumSubPillarSize (" + ((PillarSelectorConfig)this.config).getMinimumSubPillarSize() + ") or maximumSubPillarSize (" + ((PillarSelectorConfig)this.config).getMaximumSubPillarSize() + ").");
        }
        SubPillarConfigPolicy subPillarPolicy = subPillarEnabled ? this.configureSubPillars(subPillarType, subPillarSequenceComparatorClass, entitySelector, ((PillarSelectorConfig)this.config).getMinimumSubPillarSize(), ((PillarSelectorConfig)this.config).getMaximumSubPillarSize(), configPolicy.getClassInstanceCache()) : SubPillarConfigPolicy.withoutSubpillars();
        return new DefaultPillarSelector(entitySelector, variableDescriptors, inheritedSelectionOrder.toRandomSelectionBoolean(), subPillarPolicy);
    }

    private SubPillarConfigPolicy configureSubPillars(SubPillarType pillarType, Class<? extends Comparator<Object>> pillarOrderComparatorClass, EntitySelector<Solution_> entitySelector, Integer minimumSubPillarSize, Integer maximumSubPillarSize, ClassInstanceCache instanceCache) {
        int actualMinimumSubPillarSize = Objects.requireNonNullElse(minimumSubPillarSize, 1);
        int actualMaximumSubPillarSize = Objects.requireNonNullElse(maximumSubPillarSize, Integer.MAX_VALUE);
        if (pillarType == null) {
            return SubPillarConfigPolicy.withSubpillars(actualMinimumSubPillarSize, actualMaximumSubPillarSize);
        }
        switch (pillarType) {
            case ALL: {
                return SubPillarConfigPolicy.withSubpillars(actualMinimumSubPillarSize, actualMaximumSubPillarSize);
            }
            case SEQUENCE: {
                if (pillarOrderComparatorClass == null) {
                    Class<?> entityClass = entitySelector.getEntityDescriptor().getEntityClass();
                    boolean isComparable = Comparable.class.isAssignableFrom(entityClass);
                    if (!isComparable) {
                        throw new IllegalArgumentException("Pillar type (" + pillarType + ") on pillarSelectorConfig (" + this.config + ") does not provide pillarOrderComparatorClass while the entity (" + entityClass.getCanonicalName() + ") does not implement Comparable.");
                    }
                    return SubPillarConfigPolicy.sequential(actualMinimumSubPillarSize, actualMaximumSubPillarSize, Comparator.naturalOrder());
                }
                Comparator<Object> comparator = instanceCache.newInstance(this.config, "pillarOrderComparatorClass", pillarOrderComparatorClass);
                return SubPillarConfigPolicy.sequential(actualMinimumSubPillarSize, actualMaximumSubPillarSize, comparator);
            }
        }
        throw new IllegalStateException("Subpillars cannot be enabled and disabled at the same time.");
    }
}

