/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.move.DoableMoveSelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.CachingMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.FilteringMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.ProbabilityMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.SelectedCountLimitMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.ShufflingMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.SortingMoveSelector;
import java.util.Comparator;

public abstract class AbstractMoveSelectorFactory<Solution_, MoveSelectorConfig_ extends MoveSelectorConfig<MoveSelectorConfig_>>
extends AbstractSelectorFactory<Solution_, MoveSelectorConfig_>
implements MoveSelectorFactory<Solution_> {
    public AbstractMoveSelectorFactory(MoveSelectorConfig_ moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    protected abstract MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> var1, SelectionCacheType var2, boolean var3);

    @Override
    public MoveSelector<Solution_> buildMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder, boolean skipNonDoableMoves) {
        MoveSelectorConfig<?> unfoldedMoveSelectorConfig = this.buildUnfoldedMoveSelectorConfig(configPolicy);
        if (unfoldedMoveSelectorConfig != null) {
            return MoveSelectorFactory.create(unfoldedMoveSelectorConfig).buildMoveSelector(configPolicy, minimumCacheType, inheritedSelectionOrder, skipNonDoableMoves);
        }
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(((MoveSelectorConfig)this.config).getCacheType(), minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(((MoveSelectorConfig)this.config).getSelectionOrder(), inheritedSelectionOrder);
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        this.validateSelectedLimit(minimumCacheType);
        boolean randomMoveSelection = this.determineBaseRandomSelection(resolvedCacheType, resolvedSelectionOrder);
        SelectionCacheType selectionCacheType = SelectionCacheType.max(minimumCacheType, resolvedCacheType);
        MoveSelector<Solution_> moveSelector = this.buildBaseMoveSelector(configPolicy, selectionCacheType, randomMoveSelection);
        this.validateResolvedCacheType(resolvedCacheType, moveSelector);
        moveSelector = this.applyFiltering(moveSelector, skipNonDoableMoves);
        moveSelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applySelectedLimit(moveSelector);
        return moveSelector;
    }

    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        return null;
    }

    protected static void checkUnfolded(String configPropertyName, Object configProperty) {
        if (configProperty == null) {
            throw new IllegalStateException("The " + configPropertyName + " (" + configProperty + ") should haven been initialized during unfolding.");
        }
    }

    private void validateResolvedCacheType(SelectionCacheType resolvedCacheType, MoveSelector<Solution_> moveSelector) {
        if (!moveSelector.supportsPhaseAndSolverCaching() && resolvedCacheType.compareTo(SelectionCacheType.PHASE) >= 0) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") has a resolvedCacheType (" + resolvedCacheType + ") that is not supported.\nMaybe don't use a <cacheType> on this type of moveSelector.");
        }
    }

    protected boolean determineBaseRandomSelection(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        switch (resolvedSelectionOrder) {
            case ORIGINAL: {
                return false;
            }
            case SORTED: 
            case SHUFFLED: 
            case PROBABILISTIC: {
                return false;
            }
            case RANDOM: {
                return resolvedCacheType.isNotCached() || this.isBaseInherentlyCached() && !this.hasFiltering();
            }
        }
        throw new IllegalStateException("The selectionOrder (" + resolvedSelectionOrder + ") is not implemented.");
    }

    protected boolean isBaseInherentlyCached() {
        return false;
    }

    private boolean hasFiltering() {
        return ((MoveSelectorConfig)this.config).getFilterClass() != null;
    }

    private MoveSelector<Solution_> applyFiltering(MoveSelector<Solution_> moveSelector, boolean skipNonDoableMoves) {
        SelectionFilter baseFilter;
        SelectionFilter selectionFilter = baseFilter = skipNonDoableMoves ? DoableMoveSelectionFilter.INSTANCE : null;
        if (this.hasFiltering()) {
            SelectionFilter selectionFilter2 = ConfigUtils.newInstance(this.config, "filterClass", ((MoveSelectorConfig)this.config).getFilterClass());
            SelectionFilter finalFilter = baseFilter == null ? selectionFilter2 : SelectionFilter.compose(baseFilter, selectionFilter2);
            return FilteringMoveSelector.of(moveSelector, finalFilter);
        }
        if (baseFilter != null) {
            return FilteringMoveSelector.of(moveSelector, baseFilter);
        }
        return moveSelector;
    }

    protected void validateSorting(SelectionOrder resolvedSelectionOrder) {
        if ((((MoveSelectorConfig)this.config).getSorterComparatorClass() != null || ((MoveSelectorConfig)this.config).getSorterWeightFactoryClass() != null || ((MoveSelectorConfig)this.config).getSorterOrder() != null || ((MoveSelectorConfig)this.config).getSorterClass() != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") with sorterComparatorClass (" + ((MoveSelectorConfig)this.config).getSorterComparatorClass() + ") and sorterWeightFactoryClass (" + ((MoveSelectorConfig)this.config).getSorterWeightFactoryClass() + ") and sorterOrder (" + ((MoveSelectorConfig)this.config).getSorterOrder() + ") and sorterClass (" + ((MoveSelectorConfig)this.config).getSorterClass() + ") has a resolvedSelectionOrder (" + resolvedSelectionOrder + ") that is not " + SelectionOrder.SORTED + ".");
        }
        if (((MoveSelectorConfig)this.config).getSorterComparatorClass() != null && ((MoveSelectorConfig)this.config).getSorterWeightFactoryClass() != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") has both a sorterComparatorClass (" + ((MoveSelectorConfig)this.config).getSorterComparatorClass() + ") and a sorterWeightFactoryClass (" + ((MoveSelectorConfig)this.config).getSorterWeightFactoryClass() + ").");
        }
        if (((MoveSelectorConfig)this.config).getSorterComparatorClass() != null && ((MoveSelectorConfig)this.config).getSorterClass() != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") has both a sorterComparatorClass (" + ((MoveSelectorConfig)this.config).getSorterComparatorClass() + ") and a sorterClass (" + ((MoveSelectorConfig)this.config).getSorterClass() + ").");
        }
        if (((MoveSelectorConfig)this.config).getSorterWeightFactoryClass() != null && ((MoveSelectorConfig)this.config).getSorterClass() != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") has both a sorterWeightFactoryClass (" + ((MoveSelectorConfig)this.config).getSorterWeightFactoryClass() + ") and a sorterClass (" + ((MoveSelectorConfig)this.config).getSorterClass() + ").");
        }
        if (((MoveSelectorConfig)this.config).getSorterClass() != null && ((MoveSelectorConfig)this.config).getSorterOrder() != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") with sorterClass (" + ((MoveSelectorConfig)this.config).getSorterClass() + ") has a non-null sorterOrder (" + ((MoveSelectorConfig)this.config).getSorterOrder() + ").");
        }
    }

    protected MoveSelector<Solution_> applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector<Solution_> moveSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            SelectionSorter sorter;
            if (((MoveSelectorConfig)this.config).getSorterComparatorClass() != null) {
                Comparator sorterComparator = ConfigUtils.newInstance(this.config, "sorterComparatorClass", ((MoveSelectorConfig)this.config).getSorterComparatorClass());
                sorter = new ComparatorSelectionSorter(sorterComparator, SelectionSorterOrder.resolve(((MoveSelectorConfig)this.config).getSorterOrder()));
            } else if (((MoveSelectorConfig)this.config).getSorterWeightFactoryClass() != null) {
                SelectionSorterWeightFactory sorterWeightFactory = ConfigUtils.newInstance(this.config, "sorterWeightFactoryClass", ((MoveSelectorConfig)this.config).getSorterWeightFactoryClass());
                sorter = new WeightFactorySelectionSorter(sorterWeightFactory, SelectionSorterOrder.resolve(((MoveSelectorConfig)this.config).getSorterOrder()));
            } else if (((MoveSelectorConfig)this.config).getSorterClass() != null) {
                sorter = ConfigUtils.newInstance(this.config, "sorterClass", ((MoveSelectorConfig)this.config).getSorterClass());
            } else {
                throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") with resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs a sorterComparatorClass (" + ((MoveSelectorConfig)this.config).getSorterComparatorClass() + ") or a sorterWeightFactoryClass (" + ((MoveSelectorConfig)this.config).getSorterWeightFactoryClass() + ") or a sorterClass (" + ((MoveSelectorConfig)this.config).getSorterClass() + ").");
            }
            moveSelector = new SortingMoveSelector<Solution_>(moveSelector, resolvedCacheType, sorter);
        }
        return moveSelector;
    }

    private void validateProbability(SelectionOrder resolvedSelectionOrder) {
        if (((MoveSelectorConfig)this.config).getProbabilityWeightFactoryClass() != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") with probabilityWeightFactoryClass (" + ((MoveSelectorConfig)this.config).getProbabilityWeightFactoryClass() + ") has a resolvedSelectionOrder (" + resolvedSelectionOrder + ") that is not " + SelectionOrder.PROBABILISTIC + ".");
        }
    }

    private MoveSelector<Solution_> applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector<Solution_> moveSelector) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            if (((MoveSelectorConfig)this.config).getProbabilityWeightFactoryClass() == null) {
                throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") with resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs a probabilityWeightFactoryClass (" + ((MoveSelectorConfig)this.config).getProbabilityWeightFactoryClass() + ").");
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = ConfigUtils.newInstance(this.config, "probabilityWeightFactoryClass", ((MoveSelectorConfig)this.config).getProbabilityWeightFactoryClass());
            moveSelector = new ProbabilityMoveSelector<Solution_>(moveSelector, resolvedCacheType, probabilityWeightFactory);
        }
        return moveSelector;
    }

    private MoveSelector<Solution_> applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector<Solution_> moveSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            moveSelector = new ShufflingMoveSelector<Solution_>(moveSelector, resolvedCacheType);
        }
        return moveSelector;
    }

    private MoveSelector<Solution_> applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector<Solution_> moveSelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(moveSelector.getCacheType()) > 0) {
            moveSelector = new CachingMoveSelector<Solution_>(moveSelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return moveSelector;
    }

    private void validateSelectedLimit(SelectionCacheType minimumCacheType) {
        if (((MoveSelectorConfig)this.config).getSelectedCountLimit() != null && minimumCacheType.compareTo(SelectionCacheType.JUST_IN_TIME) > 0) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") with selectedCountLimit (" + ((MoveSelectorConfig)this.config).getSelectedCountLimit() + ") has a minimumCacheType (" + minimumCacheType + ") that is higher than " + SelectionCacheType.JUST_IN_TIME + ".");
        }
    }

    private MoveSelector<Solution_> applySelectedLimit(MoveSelector<Solution_> moveSelector) {
        if (((MoveSelectorConfig)this.config).getSelectedCountLimit() != null) {
            moveSelector = new SelectedCountLimitMoveSelector<Solution_>(moveSelector, ((MoveSelectorConfig)this.config).getSelectedCountLimit());
        }
        return moveSelector;
    }
}

