/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.constructionheuristic.DefaultConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseBuilder;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateUndoMove;
import ai.timefold.solver.core.impl.phase.AbstractPhase;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class RuinRecreateMove<Solution_>
extends AbstractMove<Solution_> {
    private final GenuineVariableDescriptor<Solution_> genuineVariableDescriptor;
    private final RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder;
    private final SolverScope<Solution_> solverScope;
    private final List<Object> ruinedEntityList;
    private final Set<Object> affectedValueSet;
    private Object[] recordedNewValues;

    public RuinRecreateMove(GenuineVariableDescriptor<Solution_> genuineVariableDescriptor, RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder, SolverScope<Solution_> solverScope, List<Object> ruinedEntityList, Set<Object> affectedValueSet) {
        this.genuineVariableDescriptor = genuineVariableDescriptor;
        this.ruinedEntityList = ruinedEntityList;
        this.affectedValueSet = affectedValueSet;
        this.constructionHeuristicPhaseBuilder = constructionHeuristicPhaseBuilder;
        this.solverScope = solverScope;
        this.recordedNewValues = null;
    }

    @Override
    protected Move<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        Object[] recordedOldValues = new Object[this.ruinedEntityList.size()];
        for (int i = 0; i < this.ruinedEntityList.size(); ++i) {
            recordedOldValues[i] = this.genuineVariableDescriptor.getValue(this.ruinedEntityList.get(i));
        }
        return new RuinRecreateUndoMove<Solution_>(this, this.genuineVariableDescriptor, this.ruinedEntityList, recordedOldValues);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        this.recordedNewValues = new Object[this.ruinedEntityList.size()];
        VariableDescriptorAwareScoreDirector innerScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        for (Object ruinedEntity : this.ruinedEntityList) {
            innerScoreDirector.beforeVariableChanged(this.genuineVariableDescriptor, ruinedEntity);
            this.genuineVariableDescriptor.setValue(ruinedEntity, null);
            innerScoreDirector.afterVariableChanged(this.genuineVariableDescriptor, ruinedEntity);
        }
        innerScoreDirector.triggerVariableListeners();
        AbstractPhase constructionHeuristicPhase = this.constructionHeuristicPhaseBuilder.withElementsToRecreate(this.ruinedEntityList).build();
        constructionHeuristicPhase.setSolver(this.solverScope.getSolver());
        ((DefaultConstructionHeuristicPhase)constructionHeuristicPhase).solvingStarted(this.solverScope);
        ((DefaultConstructionHeuristicPhase)constructionHeuristicPhase).solve(this.solverScope);
        ((DefaultConstructionHeuristicPhase)constructionHeuristicPhase).solvingEnded(this.solverScope);
        innerScoreDirector.triggerVariableListeners();
        for (int i = 0; i < this.ruinedEntityList.size(); ++i) {
            this.recordedNewValues[i] = this.genuineVariableDescriptor.getValue(this.ruinedEntityList.get(i));
        }
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return this.ruinedEntityList;
    }

    @Override
    public Collection<?> getPlanningValues() {
        return this.affectedValueSet;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return true;
    }

    public String toString() {
        return "RuinMove{entities=" + this.ruinedEntityList + ", newValues=" + (this.recordedNewValues != null ? Arrays.toString(this.recordedNewValues) : "?") + "}";
    }
}

