/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.CountSupplier;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseBuilder;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateMoveIterator;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import org.apache.commons.math3.util.CombinatoricsUtils;

final class RuinRecreateMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final EntitySelector<Solution_> entitySelector;
    private final GenuineVariableDescriptor<Solution_> variableDescriptor;
    private final RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder;
    private final CountSupplier minimumSelectedCountSupplier;
    private final CountSupplier maximumSelectedCountSupplier;
    private SolverScope<Solution_> solverScope;

    public RuinRecreateMoveSelector(EntitySelector<Solution_> entitySelector, GenuineVariableDescriptor<Solution_> variableDescriptor, RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder, CountSupplier minimumSelectedCountSupplier, CountSupplier maximumSelectedCountSupplier) {
        this.entitySelector = entitySelector;
        this.variableDescriptor = variableDescriptor;
        this.constructionHeuristicPhaseBuilder = constructionHeuristicPhaseBuilder;
        this.minimumSelectedCountSupplier = minimumSelectedCountSupplier;
        this.maximumSelectedCountSupplier = maximumSelectedCountSupplier;
        this.phaseLifecycleSupport.addEventListener(entitySelector);
    }

    @Override
    public long getSize() {
        long totalSize = 0L;
        long entityCount = this.entitySelector.getSize();
        int minimumSelectedCount = this.minimumSelectedCountSupplier.applyAsInt(entityCount);
        int maximumSelectedCount = this.maximumSelectedCountSupplier.applyAsInt(entityCount);
        for (int selectedCount = minimumSelectedCount; selectedCount <= maximumSelectedCount; ++selectedCount) {
            totalSize += CombinatoricsUtils.factorial((int)((int)entityCount)) / CombinatoricsUtils.factorial((int)selectedCount);
        }
        return totalSize;
    }

    @Override
    public boolean isCountable() {
        return this.entitySelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.entitySelector.isNeverEnding();
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.solverScope = solverScope;
        this.workingRandom = solverScope.getWorkingRandom();
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        long entitySelectorSize = this.entitySelector.getSize();
        return new RuinRecreateMoveIterator<Solution_>(this.entitySelector, this.variableDescriptor, this.constructionHeuristicPhaseBuilder, this.solverScope, this.minimumSelectedCountSupplier.applyAsInt(entitySelectorSize), this.maximumSelectedCountSupplier.applyAsInt(entitySelectorSize), this.workingRandom);
    }
}

