/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.SwapMoveSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwapMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, SwapMoveSelectorConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwapMoveSelectorFactory.class);

    public SwapMoveSelectorFactory(SwapMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        EntitySelectorConfig entitySelectorConfig = Objects.requireNonNullElseGet(((SwapMoveSelectorConfig)this.config).getEntitySelectorConfig(), EntitySelectorConfig::new);
        EntitySelectorConfig secondaryEntitySelectorConfig = Objects.requireNonNullElse(((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig(), entitySelectorConfig);
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntitySelector leftEntitySelector = EntitySelectorFactory.create(entitySelectorConfig).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
        EntitySelector rightEntitySelector = EntitySelectorFactory.create(secondaryEntitySelectorConfig).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
        EntityDescriptor entityDescriptor = leftEntitySelector.getEntityDescriptor();
        List variableDescriptorList = this.deduceVariableDescriptorList(entityDescriptor, ((SwapMoveSelectorConfig)this.config).getVariableNameIncludeList());
        return new SwapMoveSelector(leftEntitySelector, rightEntitySelector, variableDescriptorList, randomSelection);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        EntityDescriptor onlySecondaryEntityDescriptor;
        EntityDescriptor onlyEntityDescriptor;
        EntityDescriptor entityDescriptor = onlyEntityDescriptor = ((SwapMoveSelectorConfig)this.config).getEntitySelectorConfig() == null ? null : EntitySelectorFactory.create(((SwapMoveSelectorConfig)this.config).getEntitySelectorConfig()).extractEntityDescriptor(configPolicy);
        if (((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig() != null && onlyEntityDescriptor != (onlySecondaryEntityDescriptor = EntitySelectorFactory.create(((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig()).extractEntityDescriptor(configPolicy))) {
            throw new IllegalArgumentException("The entitySelector (" + ((SwapMoveSelectorConfig)this.config).getEntitySelectorConfig() + ")'s entityClass (" + (onlyEntityDescriptor == null ? null : onlyEntityDescriptor.getEntityClass()) + ") and secondaryEntitySelectorConfig (" + ((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig() + ")'s entityClass (" + (onlySecondaryEntityDescriptor == null ? null : onlySecondaryEntityDescriptor.getEntityClass()) + ") must be the same entity class.");
        }
        if (onlyEntityDescriptor != null) {
            List variableDescriptorList = onlyEntityDescriptor.getGenuineVariableDescriptorList();
            if (variableDescriptorList.size() == 1 && variableDescriptorList.get(0).isListVariable()) {
                return this.buildListSwapMoveSelectorConfig(variableDescriptorList.get(0), true);
            }
            SwapMoveSelectorFactory.failIfHasAnyGenuineListVariables(onlyEntityDescriptor);
            return null;
        }
        Collection<EntityDescriptor<Solution_>> entityDescriptors = configPolicy.getSolutionDescriptor().getGenuineEntityDescriptors();
        return this.buildUnfoldedMoveSelectorConfig(entityDescriptors);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(Collection<EntityDescriptor<Solution_>> entityDescriptors) {
        ArrayList<MoveSelectorConfig> moveSelectorConfigList = new ArrayList<MoveSelectorConfig>(entityDescriptors.size());
        List<GenuineVariableDescriptor<Solution_>> variableDescriptorList = entityDescriptors.iterator().next().getGenuineVariableDescriptorList();
        if (entityDescriptors.size() == 1 && variableDescriptorList.size() == 1 && variableDescriptorList.get(0).isListVariable()) {
            ListSwapMoveSelectorConfig childMoveSelectorConfig = this.buildListSwapMoveSelectorConfig((VariableDescriptor)variableDescriptorList.get(0), false);
            moveSelectorConfigList.add(childMoveSelectorConfig);
        } else {
            for (EntityDescriptor<Solution_> entityDescriptor : entityDescriptors) {
                SwapMoveSelectorFactory.failIfHasAnyGenuineListVariables(entityDescriptor);
                SwapMoveSelectorConfig childMoveSelectorConfig = new SwapMoveSelectorConfig();
                EntitySelectorConfig childEntitySelectorConfig = new EntitySelectorConfig(((SwapMoveSelectorConfig)this.config).getEntitySelectorConfig());
                if (childEntitySelectorConfig.getMimicSelectorRef() == null) {
                    childEntitySelectorConfig.setEntityClass(entityDescriptor.getEntityClass());
                }
                childMoveSelectorConfig.setEntitySelectorConfig(childEntitySelectorConfig);
                if (((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig() != null) {
                    EntitySelectorConfig childSecondaryEntitySelectorConfig = new EntitySelectorConfig(((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig());
                    if (childSecondaryEntitySelectorConfig.getMimicSelectorRef() == null) {
                        childSecondaryEntitySelectorConfig.setEntityClass(entityDescriptor.getEntityClass());
                    }
                    childMoveSelectorConfig.setSecondaryEntitySelectorConfig(childSecondaryEntitySelectorConfig);
                }
                childMoveSelectorConfig.setVariableNameIncludeList(((SwapMoveSelectorConfig)this.config).getVariableNameIncludeList());
                moveSelectorConfigList.add(childMoveSelectorConfig);
            }
        }
        MoveSelectorConfig unfoldedMoveSelectorConfig = moveSelectorConfigList.size() == 1 ? (MoveSelectorConfig)moveSelectorConfigList.get(0) : new UnionMoveSelectorConfig(moveSelectorConfigList);
        unfoldedMoveSelectorConfig.inheritFolded((MoveSelectorConfig)this.config);
        return unfoldedMoveSelectorConfig;
    }

    private static void failIfHasAnyGenuineListVariables(EntityDescriptor<?> entityDescriptor) {
        if (entityDescriptor.hasAnyGenuineListVariables()) {
            throw new IllegalArgumentException("The variableDescriptorList (" + entityDescriptor.getGenuineVariableDescriptorList() + ") has multiple variables and one or more of them is a @" + PlanningListVariable.class.getSimpleName() + ", which is currently not supported.");
        }
    }

    private ListSwapMoveSelectorConfig buildListSwapMoveSelectorConfig(VariableDescriptor<?> variableDescriptor, boolean inheritFoldedConfig) {
        LOGGER.warn("The swapMoveSelectorConfig ({}) is being used for a list variable.\nWe are keeping this option through the 1.x release stream for backward compatibility reasons.\nPlease update your solver config to use {} now.", (Object)this.config, (Object)ListSwapMoveSelectorConfig.class.getSimpleName());
        ListSwapMoveSelectorConfig listSwapMoveSelectorConfig = new ListSwapMoveSelectorConfig();
        ValueSelectorConfig childValueSelectorConfig = new ValueSelectorConfig(new ValueSelectorConfig(variableDescriptor.getVariableName()));
        listSwapMoveSelectorConfig.setValueSelectorConfig(childValueSelectorConfig);
        if (inheritFoldedConfig) {
            listSwapMoveSelectorConfig.inheritFolded((MoveSelectorConfig)this.config);
        }
        return listSwapMoveSelectorConfig;
    }
}

