/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained;

import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained.SubChainChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained.SubChainReversingChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.chained.SubChain;
import ai.timefold.solver.core.impl.heuristic.selector.value.chained.SubChainSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Collections;
import java.util.Iterator;

public class SubChainChangeMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    protected final SubChainSelector<Solution_> subChainSelector;
    protected final EntityIndependentValueSelector<Solution_> valueSelector;
    protected final boolean randomSelection;
    protected final boolean selectReversingMoveToo;
    protected SingletonInverseVariableSupply inverseVariableSupply = null;

    public SubChainChangeMoveSelector(SubChainSelector<Solution_> subChainSelector, EntityIndependentValueSelector<Solution_> valueSelector, boolean randomSelection, boolean selectReversingMoveToo) {
        this.subChainSelector = subChainSelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        this.selectReversingMoveToo = selectReversingMoveToo;
        if (subChainSelector.getVariableDescriptor() != valueSelector.getVariableDescriptor()) {
            throw new IllegalStateException("The selector (" + this + ") has a subChainSelector (" + subChainSelector + ") with variableDescriptor (" + subChainSelector.getVariableDescriptor() + ") which is not the same as the valueSelector (" + valueSelector + ")'s variableDescriptor(" + valueSelector.getVariableDescriptor() + ").");
        }
        if (!randomSelection) {
            if (subChainSelector.isNeverEnding()) {
                throw new IllegalStateException("The selector (" + this + ") has a subChainSelector (" + subChainSelector + ") with neverEnding (" + subChainSelector.isNeverEnding() + ").");
            }
            if (valueSelector.isNeverEnding()) {
                throw new IllegalStateException("The selector (" + this + ") has a valueSelector (" + valueSelector + ") with neverEnding (" + valueSelector.isNeverEnding() + ").");
            }
        }
        this.phaseLifecycleSupport.addEventListener(subChainSelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.inverseVariableSupply = supplyManager.demand(new SingletonInverseVariableDemand(this.valueSelector.getVariableDescriptor()));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        return this.subChainSelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.subChainSelector.getSize() * this.valueSelector.getSize();
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (!this.randomSelection) {
            return new OriginalSubChainChangeMoveIterator();
        }
        return new RandomSubChainChangeMoveIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.subChainSelector + ", " + this.valueSelector + ")";
    }

    private class OriginalSubChainChangeMoveIterator
    extends UpcomingSelectionIterator<Move<Solution_>> {
        private final Iterator<SubChain> subChainIterator;
        private Iterator<Object> valueIterator = null;
        private SubChain upcomingSubChain;
        private Move<Solution_> nextReversingSelection = null;

        private OriginalSubChainChangeMoveIterator() {
            this.subChainIterator = SubChainChangeMoveSelector.this.subChainSelector.iterator();
            this.valueIterator = Collections.emptyIterator();
        }

        @Override
        protected Move<Solution_> createUpcomingSelection() {
            if (SubChainChangeMoveSelector.this.selectReversingMoveToo && this.nextReversingSelection != null) {
                Move upcomingSelection = this.nextReversingSelection;
                this.nextReversingSelection = null;
                return upcomingSelection;
            }
            if (!this.valueIterator.hasNext()) {
                if (!this.subChainIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
                this.upcomingSubChain = this.subChainIterator.next();
                this.valueIterator = SubChainChangeMoveSelector.this.valueSelector.iterator();
                if (!this.valueIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
            }
            Object toValue = this.valueIterator.next();
            SubChainChangeMove upcomingSelection = new SubChainChangeMove(this.upcomingSubChain, SubChainChangeMoveSelector.this.valueSelector.getVariableDescriptor(), SubChainChangeMoveSelector.this.inverseVariableSupply, toValue);
            if (SubChainChangeMoveSelector.this.selectReversingMoveToo) {
                this.nextReversingSelection = new SubChainReversingChangeMove(this.upcomingSubChain, SubChainChangeMoveSelector.this.valueSelector.getVariableDescriptor(), SubChainChangeMoveSelector.this.inverseVariableSupply, toValue);
            }
            return upcomingSelection;
        }
    }

    private class RandomSubChainChangeMoveIterator
    extends UpcomingSelectionIterator<Move<Solution_>> {
        private Iterator<SubChain> subChainIterator;
        private Iterator<Object> valueIterator;

        private RandomSubChainChangeMoveIterator() {
            this.subChainIterator = SubChainChangeMoveSelector.this.subChainSelector.iterator();
            this.valueIterator = SubChainChangeMoveSelector.this.valueSelector.iterator();
            this.valueIterator = Collections.emptyIterator();
        }

        @Override
        protected Move<Solution_> createUpcomingSelection() {
            if (!this.subChainIterator.hasNext()) {
                this.subChainIterator = SubChainChangeMoveSelector.this.subChainSelector.iterator();
                if (!this.subChainIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
            }
            SubChain subChain = this.subChainIterator.next();
            if (!this.valueIterator.hasNext()) {
                this.valueIterator = SubChainChangeMoveSelector.this.valueSelector.iterator();
                if (!this.valueIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
            }
            Object toValue = this.valueIterator.next();
            boolean reversing = SubChainChangeMoveSelector.this.selectReversingMoveToo && SubChainChangeMoveSelector.this.workingRandom.nextBoolean();
            return reversing ? new SubChainReversingChangeMove(subChain, SubChainChangeMoveSelector.this.valueSelector.getVariableDescriptor(), SubChainChangeMoveSelector.this.inverseVariableSupply, toValue) : new SubChainChangeMove(subChain, SubChainChangeMoveSelector.this.valueSelector.getVariableDescriptor(), SubChainChangeMoveSelector.this.inverseVariableSupply, toValue);
        }
    }
}

