/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained;

import ai.timefold.solver.core.impl.domain.variable.anchor.AnchorVariableDemand;
import ai.timefold.solver.core.impl.domain.variable.anchor.AnchorVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.IterableSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.AbstractOriginalChangeIterator;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.AbstractRandomChangeIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained.TailChainSwapMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;

public class TailChainSwapMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    protected final EntitySelector<Solution_> entitySelector;
    protected final ValueSelector<Solution_> valueSelector;
    protected final boolean randomSelection;
    protected SingletonInverseVariableSupply inverseVariableSupply;
    protected AnchorVariableSupply anchorVariableSupply;

    public TailChainSwapMoveSelector(EntitySelector<Solution_> entitySelector, ValueSelector<Solution_> valueSelector, boolean randomSelection) {
        BasicVariableDescriptor basicVariableDescriptor;
        boolean isChained;
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        GenuineVariableDescriptor<Solution_> variableDescriptor = valueSelector.getVariableDescriptor();
        boolean bl = isChained = variableDescriptor instanceof BasicVariableDescriptor && (basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor).isChained();
        if (!isChained) {
            throw new IllegalStateException("The selector (%s)'s valueSelector's variableDescriptor (%s) must be chained (%s).".formatted(this, variableDescriptor, isChained));
        }
        if (!variableDescriptor.getEntityDescriptor().getEntityClass().isAssignableFrom(entitySelector.getEntityDescriptor().getEntityClass())) {
            throw new IllegalStateException("The selector (" + this + ") has a valueSelector with a entityClass (" + variableDescriptor.getEntityDescriptor().getEntityClass() + ") which is not equal or a superclass to the entitySelector's entityClass (" + entitySelector.getEntityDescriptor().getEntityClass() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        GenuineVariableDescriptor<Solution_> variableDescriptor = this.valueSelector.getVariableDescriptor();
        this.inverseVariableSupply = supplyManager.demand(new SingletonInverseVariableDemand<Solution_>(variableDescriptor));
        this.anchorVariableSupply = supplyManager.demand(new AnchorVariableDemand<Solution_>(variableDescriptor));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.anchorVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        return this.entitySelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.entitySelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        if (this.valueSelector instanceof IterableSelector) {
            return this.entitySelector.getSize() * ((IterableSelector)((Object)this.valueSelector)).getSize();
        }
        long size = 0L;
        Iterator<Object> it = this.entitySelector.endingIterator();
        while (it.hasNext()) {
            Object entity = it.next();
            size += this.valueSelector.getSize(entity);
        }
        return size;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        final GenuineVariableDescriptor<Solution_> variableDescriptor = this.valueSelector.getVariableDescriptor();
        if (!this.randomSelection) {
            return new AbstractOriginalChangeIterator<Solution_, Move<Solution_>>(this.entitySelector, this.valueSelector){

                @Override
                protected Move<Solution_> newChangeSelection(Object entity, Object toValue) {
                    return new TailChainSwapMove(variableDescriptor, TailChainSwapMoveSelector.this.inverseVariableSupply, TailChainSwapMoveSelector.this.anchorVariableSupply, entity, toValue);
                }
            };
        }
        return new AbstractRandomChangeIterator<Solution_, Move<Solution_>>(this.entitySelector, this.valueSelector){

            @Override
            protected Move<Solution_> newChangeSelection(Object entity, Object toValue) {
                return new TailChainSwapMove(variableDescriptor, TailChainSwapMoveSelector.this.inverseVariableSupply, TailChainSwapMoveSelector.this.anchorVariableSupply, entity, toValue);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ", " + this.valueSelector + ")";
    }
}

