/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractSimplifiedMove;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class ListAssignMove<Solution_>
extends AbstractSimplifiedMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object planningValue;
    private final Object destinationEntity;
    private final int destinationIndex;

    public ListAssignMove(ListVariableDescriptor<Solution_> variableDescriptor, Object planningValue, Object destinationEntity, int destinationIndex) {
        this.variableDescriptor = variableDescriptor;
        this.planningValue = planningValue;
        this.destinationEntity = destinationEntity;
        this.destinationIndex = destinationIndex;
    }

    public Object getDestinationEntity() {
        return this.destinationEntity;
    }

    public int getDestinationIndex() {
        return this.destinationIndex;
    }

    public Object getMovedValue() {
        return this.planningValue;
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return List.of(this.destinationEntity);
    }

    @Override
    public Collection<?> getPlanningValues() {
        return List.of(this.planningValue);
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return this.destinationIndex >= 0 && this.variableDescriptor.getListSize(this.destinationEntity) >= this.destinationIndex;
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        VariableDescriptorAwareScoreDirector variableDescriptorAwareScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        variableDescriptorAwareScoreDirector.beforeListVariableElementAssigned(this.variableDescriptor, this.planningValue);
        variableDescriptorAwareScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.destinationEntity, this.destinationIndex, this.destinationIndex);
        this.variableDescriptor.addElement(this.destinationEntity, this.destinationIndex, this.planningValue);
        variableDescriptorAwareScoreDirector.afterListVariableChanged(this.variableDescriptor, this.destinationEntity, this.destinationIndex, this.destinationIndex + 1);
        variableDescriptorAwareScoreDirector.afterListVariableElementAssigned(this.variableDescriptor, this.planningValue);
    }

    @Override
    public ListAssignMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new ListAssignMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.planningValue), destinationScoreDirector.lookUpWorkingObject(this.destinationEntity), this.destinationIndex);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListAssignMove other = (ListAssignMove)o;
        return this.destinationIndex == other.destinationIndex && Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.planningValue, other.planningValue) && Objects.equals(this.destinationEntity, other.destinationEntity);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.planningValue, this.destinationEntity, this.destinationIndex);
    }

    @Override
    public String toString() {
        return String.format("%s {null -> %s[%d]}", this.getMovedValue(), this.destinationEntity, this.destinationIndex);
    }
}

