/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractSimplifiedMove;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ListUnassignMove<Solution_>
extends AbstractSimplifiedMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object sourceEntity;
    private final int sourceIndex;
    private Object movedValue;

    public ListUnassignMove(ListVariableDescriptor<Solution_> variableDescriptor, Object sourceEntity, int sourceIndex) {
        this.variableDescriptor = variableDescriptor;
        this.sourceEntity = sourceEntity;
        this.sourceIndex = sourceIndex;
    }

    public Object getSourceEntity() {
        return this.sourceEntity;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public Object getMovedValue() {
        if (this.movedValue == null) {
            this.movedValue = this.variableDescriptor.getElement(this.sourceEntity, this.sourceIndex);
        }
        return this.movedValue;
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return List.of(this.sourceEntity);
    }

    @Override
    public Collection<?> getPlanningValues() {
        return List.of(this.getMovedValue());
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return this.variableDescriptor.getElement(this.sourceEntity, this.sourceIndex) != null;
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        VariableDescriptorAwareScoreDirector innerScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        Object listVariable = this.variableDescriptor.getValue(this.sourceEntity);
        Object element = this.getMovedValue();
        innerScoreDirector.beforeListVariableElementUnassigned(this.variableDescriptor, element);
        innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.sourceEntity, this.sourceIndex, this.sourceIndex + 1);
        this.movedValue = listVariable.remove(this.sourceIndex);
        innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.sourceEntity, this.sourceIndex, this.sourceIndex);
        innerScoreDirector.afterListVariableElementUnassigned(this.variableDescriptor, element);
    }

    @Override
    public Move<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new ListUnassignMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.sourceEntity), this.sourceIndex);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof ListUnassignMove) {
            ListUnassignMove other = (ListUnassignMove)o;
            return this.sourceIndex == other.sourceIndex && Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.sourceEntity, other.sourceEntity);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.sourceEntity, this.sourceIndex);
    }

    @Override
    public String toString() {
        return String.format("%s {%s[%d] -> null}", this.getMovedValue(), this.sourceEntity, this.sourceIndex);
    }
}

