/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractSimplifiedMove;
import ai.timefold.solver.core.impl.heuristic.move.CompositeMove;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.move.NoChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.list.ElementLocation;
import ai.timefold.solver.core.impl.heuristic.selector.list.LocationInList;
import ai.timefold.solver.core.impl.heuristic.selector.list.UnassignedLocation;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListAssignMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListSwapMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListUnassignMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import java.util.Collections;
import java.util.Iterator;

public class OriginalListSwapIterator<Solution_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final ListVariableStateSupply<Solution_> listVariableStateSupply;
    private final Iterator<Object> leftValueIterator;
    private final EntityIndependentValueSelector<Solution_> rightValueSelector;
    private Iterator<Object> rightValueIterator;
    private Object upcomingLeftValue;

    public OriginalListSwapIterator(ListVariableStateSupply<Solution_> listVariableStateSupply, EntityIndependentValueSelector<Solution_> leftValueSelector, EntityIndependentValueSelector<Solution_> rightValueSelector) {
        this.listVariableStateSupply = listVariableStateSupply;
        this.leftValueIterator = leftValueSelector.iterator();
        this.rightValueSelector = rightValueSelector;
        this.rightValueIterator = Collections.emptyIterator();
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        while (!this.rightValueIterator.hasNext()) {
            if (!this.leftValueIterator.hasNext()) {
                return (Move)this.noUpcomingSelection();
            }
            this.upcomingLeftValue = this.leftValueIterator.next();
            this.rightValueIterator = this.rightValueSelector.iterator();
        }
        Object upcomingRightValue = this.rightValueIterator.next();
        return OriginalListSwapIterator.buildSwapMove(this.listVariableStateSupply, this.upcomingLeftValue, upcomingRightValue);
    }

    static <Solution_> Move<Solution_> buildSwapMove(ListVariableStateSupply<Solution_> listVariableStateSupply, Object upcomingLeftValue, Object upcomingRightValue) {
        if (upcomingLeftValue == upcomingRightValue) {
            return NoChangeMove.getInstance();
        }
        VariableDescriptor listVariableDescriptor = listVariableStateSupply.getSourceVariableDescriptor();
        ElementLocation upcomingLeft = listVariableStateSupply.getLocationInList(upcomingLeftValue);
        ElementLocation upcomingRight = listVariableStateSupply.getLocationInList(upcomingRightValue);
        boolean leftUnassigned = upcomingLeft instanceof UnassignedLocation;
        boolean rightUnassigned = upcomingRight instanceof UnassignedLocation;
        if (leftUnassigned && rightUnassigned) {
            return NoChangeMove.getInstance();
        }
        if (leftUnassigned) {
            LocationInList rightDestination = (LocationInList)upcomingRight;
            ListUnassignMove unassignMove = new ListUnassignMove(listVariableDescriptor, rightDestination.entity(), rightDestination.index());
            ListAssignMove assignMove = new ListAssignMove(listVariableDescriptor, upcomingLeftValue, rightDestination.entity(), rightDestination.index());
            return CompositeMove.buildMove((Move[])new AbstractSimplifiedMove[]{unassignMove, assignMove});
        }
        if (rightUnassigned) {
            LocationInList leftDestination = (LocationInList)upcomingLeft;
            ListUnassignMove unassignMove = new ListUnassignMove(listVariableDescriptor, leftDestination.entity(), leftDestination.index());
            ListAssignMove assignMove = new ListAssignMove(listVariableDescriptor, upcomingRightValue, leftDestination.entity(), leftDestination.index());
            return CompositeMove.buildMove((Move[])new AbstractSimplifiedMove[]{unassignMove, assignMove});
        }
        LocationInList leftDestination = (LocationInList)upcomingLeft;
        LocationInList rightDestination = (LocationInList)upcomingRight;
        return new ListSwapMove(listVariableDescriptor, leftDestination.entity(), leftDestination.index(), rightDestination.entity(), rightDestination.index());
    }
}

