/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubList;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;

public class SubListChangeMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object sourceEntity;
    private final int sourceIndex;
    private final int length;
    private final Object destinationEntity;
    private final int destinationIndex;
    private final boolean reversing;
    private Collection<Object> planningValues;

    public SubListChangeMove(ListVariableDescriptor<Solution_> variableDescriptor, SubList subList, Object destinationEntity, int destinationIndex, boolean reversing) {
        this(variableDescriptor, subList.entity(), subList.fromIndex(), subList.length(), destinationEntity, destinationIndex, reversing);
    }

    public SubListChangeMove(ListVariableDescriptor<Solution_> variableDescriptor, Object sourceEntity, int sourceIndex, int length, Object destinationEntity, int destinationIndex, boolean reversing) {
        this.variableDescriptor = variableDescriptor;
        this.sourceEntity = sourceEntity;
        this.sourceIndex = sourceIndex;
        this.length = length;
        this.destinationEntity = destinationEntity;
        this.destinationIndex = destinationIndex;
        this.reversing = reversing;
    }

    public Object getSourceEntity() {
        return this.sourceEntity;
    }

    public int getFromIndex() {
        return this.sourceIndex;
    }

    public int getSubListSize() {
        return this.length;
    }

    public int getToIndex() {
        return this.sourceIndex + this.length;
    }

    public boolean isReversing() {
        return this.reversing;
    }

    public Object getDestinationEntity() {
        return this.destinationEntity;
    }

    public int getDestinationIndex() {
        return this.destinationIndex;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        if (this.destinationEntity != this.sourceEntity) {
            return true;
        }
        if (this.destinationIndex == this.sourceIndex) {
            return false;
        }
        return this.destinationIndex + this.length <= this.variableDescriptor.getListSize(this.destinationEntity);
    }

    @Override
    protected AbstractMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        return new SubListChangeMove<Solution_>(this.variableDescriptor, this.destinationEntity, this.destinationIndex, this.length, this.sourceEntity, this.sourceIndex, this.reversing);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object sourceList = this.variableDescriptor.getValue(this.sourceEntity);
        List subList = sourceList.subList(this.sourceIndex, this.sourceIndex + this.length);
        this.planningValues = CollectionUtils.copy(subList, this.reversing);
        if (this.sourceEntity == this.destinationEntity) {
            int fromIndex = Math.min(this.sourceIndex, this.destinationIndex);
            int toIndex = Math.max(this.sourceIndex, this.destinationIndex) + this.length;
            innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.sourceEntity, fromIndex, toIndex);
            subList.clear();
            this.variableDescriptor.getValue(this.destinationEntity).addAll(this.destinationIndex, this.planningValues);
            innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.sourceEntity, fromIndex, toIndex);
        } else {
            innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.sourceEntity, this.sourceIndex, this.sourceIndex + this.length);
            subList.clear();
            innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.sourceEntity, this.sourceIndex, this.sourceIndex);
            innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.destinationEntity, this.destinationIndex, this.destinationIndex);
            this.variableDescriptor.getValue(this.destinationEntity).addAll(this.destinationIndex, this.planningValues);
            innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.destinationEntity, this.destinationIndex, this.destinationIndex + this.length);
        }
    }

    @Override
    public SubListChangeMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new SubListChangeMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.sourceEntity), this.sourceIndex, this.length, destinationScoreDirector.lookUpWorkingObject(this.destinationEntity), this.destinationIndex, this.reversing);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<Object> getPlanningEntities() {
        LinkedHashSet<Object> entities = new LinkedHashSet<Object>(2);
        entities.add(this.sourceEntity);
        entities.add(this.destinationEntity);
        return entities;
    }

    @Override
    public Collection<Object> getPlanningValues() {
        return this.planningValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubListChangeMove other = (SubListChangeMove)o;
        return this.sourceIndex == other.sourceIndex && this.length == other.length && this.destinationIndex == other.destinationIndex && this.reversing == other.reversing && this.variableDescriptor.equals(other.variableDescriptor) && this.sourceEntity.equals(other.sourceEntity) && this.destinationEntity.equals(other.destinationEntity);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.sourceEntity, this.sourceIndex, this.length, this.destinationEntity, this.destinationIndex, this.reversing);
    }

    public String toString() {
        return String.format("|%d| {%s[%d..%d] -%s> %s[%d]}", this.length, this.sourceEntity, this.sourceIndex, this.getToIndex(), this.reversing ? "reversing-" : "", this.destinationEntity, this.destinationIndex);
    }
}

