/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.DestinationSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.SubListSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.SubListChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.RandomSubListChangeMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.SubListConfigUtil;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SubListChangeMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, SubListChangeMoveSelectorConfig> {
    public SubListChangeMoveSelectorFactory(SubListChangeMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        SubListChangeMoveSelectorFactory.checkUnfolded("subListSelectorConfig", ((SubListChangeMoveSelectorConfig)this.config).getSubListSelectorConfig());
        SubListChangeMoveSelectorFactory.checkUnfolded("destinationSelectorConfig", ((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig());
        if (!randomSelection) {
            throw new IllegalArgumentException("The subListChangeMoveSelector (" + this.config + ") only supports random selection order.");
        }
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntitySelector entitySelector = EntitySelectorFactory.create(((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getEntitySelectorConfig()).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
        SubListSelector subListSelector = SubListSelectorFactory.create(((SubListChangeMoveSelectorConfig)this.config).getSubListSelectorConfig()).buildSubListSelector(configPolicy, entitySelector, minimumCacheType, selectionOrder);
        DestinationSelector destinationSelector = DestinationSelectorFactory.create(((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig()).buildDestinationSelector(configPolicy, minimumCacheType, randomSelection);
        boolean selectReversingMoveToo = Objects.requireNonNullElse(((SubListChangeMoveSelectorConfig)this.config).getSelectReversingMoveToo(), true);
        return new RandomSubListChangeMoveSelector(subListSelector, destinationSelector, selectReversingMoveToo);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        GenuineVariableDescriptor onlyDestinationVariableDescriptor;
        GenuineVariableDescriptor onlySubListVariableDescriptor;
        EntityDescriptor onlyEntityDescriptor = ((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig() == null ? null : (((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getEntitySelectorConfig() == null ? null : EntitySelectorFactory.create(((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getEntitySelectorConfig()).extractEntityDescriptor(configPolicy));
        Collection<Object> entityDescriptors = onlyEntityDescriptor != null ? Collections.singletonList(onlyEntityDescriptor) : configPolicy.getSolutionDescriptor().getGenuineEntityDescriptors();
        if (entityDescriptors.size() > 1) {
            throw new IllegalArgumentException("The subListChangeMoveSelector (" + this.config + ") cannot unfold when there are multiple entities (" + entityDescriptors + "). Please use one subListChangeMoveSelector per each planning list variable.");
        }
        EntityDescriptor entityDescriptor = (EntityDescriptor)entityDescriptors.iterator().next();
        ArrayList<ListVariableDescriptor> variableDescriptorList = new ArrayList<ListVariableDescriptor>();
        GenuineVariableDescriptor genuineVariableDescriptor = ((SubListChangeMoveSelectorConfig)this.config).getSubListSelectorConfig() == null ? null : (onlySubListVariableDescriptor = ((SubListChangeMoveSelectorConfig)this.config).getSubListSelectorConfig().getValueSelectorConfig() == null ? null : ValueSelectorFactory.create(((SubListChangeMoveSelectorConfig)this.config).getSubListSelectorConfig().getValueSelectorConfig()).extractVariableDescriptor(configPolicy, entityDescriptor));
        GenuineVariableDescriptor genuineVariableDescriptor2 = ((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig() == null ? null : (onlyDestinationVariableDescriptor = ((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getValueSelectorConfig() == null ? null : ValueSelectorFactory.create(((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getValueSelectorConfig()).extractVariableDescriptor(configPolicy, entityDescriptor));
        if (onlySubListVariableDescriptor != null && onlyDestinationVariableDescriptor != null) {
            if (!onlySubListVariableDescriptor.isListVariable()) {
                throw new IllegalArgumentException("The subListChangeMoveSelector (" + this.config + ") is configured to use a planning variable (" + onlySubListVariableDescriptor + "), which is not a planning list variable.");
            }
            if (!onlyDestinationVariableDescriptor.isListVariable()) {
                throw new IllegalArgumentException("The subListChangeMoveSelector (" + this.config + ") is configured to use a planning variable (" + onlyDestinationVariableDescriptor + "), which is not a planning list variable.");
            }
            if (onlySubListVariableDescriptor != onlyDestinationVariableDescriptor) {
                throw new IllegalArgumentException("The subListSelector's valueSelector (" + ((SubListChangeMoveSelectorConfig)this.config).getSubListSelectorConfig().getValueSelectorConfig() + ") and destinationSelector's valueSelector (" + ((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getValueSelectorConfig() + ") must be configured for the same planning variable.");
            }
            if (onlyEntityDescriptor != null) {
                return null;
            }
            variableDescriptorList.add((ListVariableDescriptor)onlySubListVariableDescriptor);
        } else {
            variableDescriptorList.addAll(entityDescriptor.getGenuineVariableDescriptorList().stream().filter(VariableDescriptor::isListVariable).map(variableDescriptor -> (ListVariableDescriptor)variableDescriptor).collect(Collectors.toList()));
        }
        if (variableDescriptorList.isEmpty()) {
            throw new IllegalArgumentException("The subListChangeMoveSelector (" + this.config + ") cannot unfold because there are no planning list variables.");
        }
        if (variableDescriptorList.size() > 1) {
            throw new IllegalArgumentException("The subListChangeMoveSelector (" + this.config + ") cannot unfold because there are multiple planning list variables.");
        }
        return this.buildChildMoveSelectorConfig((ListVariableDescriptor)variableDescriptorList.get(0));
    }

    private SubListChangeMoveSelectorConfig buildChildMoveSelectorConfig(ListVariableDescriptor<?> variableDescriptor) {
        SubListChangeMoveSelectorConfig subListChangeMoveSelectorConfig = ((SubListChangeMoveSelectorConfig)this.config).copyConfig().withSubListSelectorConfig(new SubListSelectorConfig(((SubListChangeMoveSelectorConfig)this.config).getSubListSelectorConfig()).withValueSelectorConfig(Optional.ofNullable(((SubListChangeMoveSelectorConfig)this.config).getSubListSelectorConfig()).map(SubListSelectorConfig::getValueSelectorConfig).map(ValueSelectorConfig::new).orElseGet(ValueSelectorConfig::new))).withDestinationSelectorConfig(new DestinationSelectorConfig(((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig()).withEntitySelectorConfig(Optional.ofNullable(((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig()).map(DestinationSelectorConfig::getEntitySelectorConfig).map(EntitySelectorConfig::new).orElseGet(EntitySelectorConfig::new).withEntityClass(variableDescriptor.getEntityDescriptor().getEntityClass())).withValueSelectorConfig(Optional.ofNullable(((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig()).map(DestinationSelectorConfig::getValueSelectorConfig).map(ValueSelectorConfig::new).orElseGet(ValueSelectorConfig::new).withVariableName(variableDescriptor.getVariableName())));
        SubListSelectorConfig subListSelectorConfig = subListChangeMoveSelectorConfig.getSubListSelectorConfig();
        SubListConfigUtil.transferDeprecatedMinimumSubListSize(subListChangeMoveSelectorConfig, SubListChangeMoveSelectorConfig::getMinimumSubListSize, "subListSelector", subListSelectorConfig);
        SubListConfigUtil.transferDeprecatedMaximumSubListSize(subListChangeMoveSelectorConfig, SubListChangeMoveSelectorConfig::getMaximumSubListSize, "subListSelector", subListSelectorConfig);
        if (subListSelectorConfig.getMimicSelectorRef() == null) {
            subListSelectorConfig.getValueSelectorConfig().setVariableName(variableDescriptor.getVariableName());
        }
        return subListChangeMoveSelectorConfig;
    }
}

