/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.FlipSublistAction;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptAffectedElements;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.MultipleDelegateList;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.UndoKOptListMove;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class KOptListMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final KOptDescriptor<?> descriptor;
    private final List<FlipSublistAction> equivalent2Opts;
    private final KOptAffectedElements affectedElementsInfo;
    private final int postShiftAmount;
    private final int[] newEndIndices;
    private final Object[] originalEntities;

    KOptListMove(ListVariableDescriptor<Solution_> listVariableDescriptor, KOptDescriptor<?> descriptor, MultipleDelegateList<?> combinedList, List<FlipSublistAction> equivalent2Opts, int postShiftAmount, int[] newEndIndices) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.descriptor = descriptor;
        this.equivalent2Opts = equivalent2Opts;
        this.postShiftAmount = postShiftAmount;
        this.newEndIndices = newEndIndices;
        if (equivalent2Opts.isEmpty()) {
            this.affectedElementsInfo = KOptAffectedElements.forMiddleRange(0, 0);
        } else if (postShiftAmount != 0) {
            this.affectedElementsInfo = KOptAffectedElements.forMiddleRange(0, combinedList.size());
        } else {
            KOptAffectedElements currentAffectedElements = equivalent2Opts.get(0).getAffectedElements();
            for (int i = 1; i < equivalent2Opts.size(); ++i) {
                currentAffectedElements = currentAffectedElements.merge(equivalent2Opts.get(i).getAffectedElements());
            }
            this.affectedElementsInfo = currentAffectedElements;
        }
        this.originalEntities = combinedList.delegateEntities;
    }

    private KOptListMove(ListVariableDescriptor<Solution_> listVariableDescriptor, KOptDescriptor<?> descriptor, List<FlipSublistAction> equivalent2Opts, int postShiftAmount, int[] newEndIndices, Object[] originalEntities) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.descriptor = descriptor;
        this.equivalent2Opts = equivalent2Opts;
        this.postShiftAmount = postShiftAmount;
        this.newEndIndices = newEndIndices;
        if (equivalent2Opts.isEmpty()) {
            this.affectedElementsInfo = KOptAffectedElements.forMiddleRange(0, 0);
        } else if (postShiftAmount != 0) {
            this.affectedElementsInfo = KOptAffectedElements.forMiddleRange(0, KOptListMove.computeCombinedList(listVariableDescriptor, originalEntities).size());
        } else {
            KOptAffectedElements currentAffectedElements = equivalent2Opts.get(0).getAffectedElements();
            for (int i = 1; i < equivalent2Opts.size(); ++i) {
                currentAffectedElements = currentAffectedElements.merge(equivalent2Opts.get(i).getAffectedElements());
            }
            this.affectedElementsInfo = currentAffectedElements;
        }
        this.originalEntities = originalEntities;
    }

    KOptDescriptor<?> getDescriptor() {
        return this.descriptor;
    }

    @Override
    protected Move<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        if (this.equivalent2Opts.isEmpty()) {
            return this;
        }
        ArrayList<FlipSublistAction> inverse2Opts = new ArrayList<FlipSublistAction>(this.equivalent2Opts.size());
        for (int i = this.equivalent2Opts.size() - 1; i >= 0; --i) {
            inverse2Opts.add(this.equivalent2Opts.get(i).createUndoMove());
        }
        MultipleDelegateList<?> combinedList = KOptListMove.computeCombinedList(this.listVariableDescriptor, this.originalEntities);
        int[] originalEndIndices = new int[this.newEndIndices.length];
        for (int i = 0; i < originalEndIndices.length - 1; ++i) {
            originalEndIndices[i] = combinedList.offsets[i + 1] - 1;
        }
        originalEndIndices[originalEndIndices.length - 1] = combinedList.size() - 1;
        return new UndoKOptListMove<Solution_>(this, this.listVariableDescriptor, inverse2Opts, -this.postShiftAmount, originalEndIndices, this.originalEntities);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        MultipleDelegateList<Object> combinedList = KOptListMove.computeCombinedList(this.listVariableDescriptor, this.originalEntities);
        combinedList.actOnAffectedElements(this.listVariableDescriptor, this.originalEntities, (entity, start, end) -> innerScoreDirector.beforeListVariableChanged(this.listVariableDescriptor, entity, (int)start, (int)end));
        MultipleDelegateList<?> combinedListCopy = combinedList.copy();
        for (FlipSublistAction move : this.equivalent2Opts) {
            move.doMoveOnGenuineVariables(combinedListCopy);
        }
        combinedListCopy.moveElementsOfDelegates(this.newEndIndices);
        Collections.rotate(combinedListCopy, this.postShiftAmount);
        combinedList.applyChangesFromCopy(combinedListCopy);
        combinedList.actOnAffectedElements(this.listVariableDescriptor, this.originalEntities, (entity, start, end) -> innerScoreDirector.afterListVariableChanged(this.listVariableDescriptor, entity, (int)start, (int)end));
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return !this.equivalent2Opts.isEmpty();
    }

    @Override
    public KOptListMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        ArrayList<FlipSublistAction> rebasedEquivalent2Opts = new ArrayList<FlipSublistAction>(this.equivalent2Opts.size());
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)destinationScoreDirector;
        Object[] newEntities = new Object[this.originalEntities.length];
        for (int i = 0; i < newEntities.length; ++i) {
            newEntities[i] = innerScoreDirector.lookUpWorkingObject(this.originalEntities[i]);
        }
        for (FlipSublistAction twoOpt : this.equivalent2Opts) {
            rebasedEquivalent2Opts.add(twoOpt.rebase());
        }
        return new KOptListMove<Solution_>(this.listVariableDescriptor, this.descriptor, rebasedEquivalent2Opts, this.postShiftAmount, this.newEndIndices, newEntities);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.descriptor.k() + "-opt(" + this.listVariableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return List.of(this.originalEntities);
    }

    @Override
    public Collection<?> getPlanningValues() {
        ArrayList out = new ArrayList();
        MultipleDelegateList<?> combinedList = KOptListMove.computeCombinedList(this.listVariableDescriptor, this.originalEntities);
        if (this.affectedElementsInfo.wrappedStartIndex() != -1) {
            out.addAll(combinedList.subList(this.affectedElementsInfo.wrappedStartIndex(), combinedList.size()));
            out.addAll(combinedList.subList(0, this.affectedElementsInfo.wrappedEndIndex()));
        }
        for (KOptAffectedElements.Range affectedRange : this.affectedElementsInfo.affectedMiddleRangeList()) {
            out.addAll(combinedList.subList(affectedRange.startInclusive(), affectedRange.endExclusive()));
        }
        return out;
    }

    public String toString() {
        return this.descriptor.toString();
    }

    static <Solution_> MultipleDelegateList<?> computeCombinedList(ListVariableDescriptor<Solution_> listVariableDescriptor, Object[] entities) {
        List[] delegates = new List[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            delegates[i] = listVariableDescriptor.getUnpinnedSubList(entities[i]);
        }
        return new MultipleDelegateList(entities, delegates);
    }
}

