/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.FlipSublistAction;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class TwoOptListMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object firstEntity;
    private final Object secondEntity;
    private final int firstEdgeEndpoint;
    private final int secondEdgeEndpoint;
    private final int shift;
    private final int entityFirstUnpinnedIndex;

    public TwoOptListMove(ListVariableDescriptor<Solution_> variableDescriptor, Object firstEntity, Object secondEntity, int firstEdgeEndpoint, int secondEdgeEndpoint) {
        this.variableDescriptor = variableDescriptor;
        this.firstEntity = firstEntity;
        this.secondEntity = secondEntity;
        this.firstEdgeEndpoint = firstEdgeEndpoint;
        this.secondEdgeEndpoint = secondEdgeEndpoint;
        if (firstEntity == secondEntity) {
            this.entityFirstUnpinnedIndex = variableDescriptor.getFirstUnpinnedIndex(firstEntity);
            if (firstEdgeEndpoint == 0) {
                this.shift = -secondEdgeEndpoint;
            } else if (secondEdgeEndpoint < firstEdgeEndpoint) {
                int listSize = variableDescriptor.getListSize(firstEntity);
                int flippedSectionSize = listSize - firstEdgeEndpoint + secondEdgeEndpoint;
                int firstElementIndexInFlipped = listSize - firstEdgeEndpoint;
                int firstElementMirroredIndex = flippedSectionSize - firstElementIndexInFlipped;
                this.shift = -(firstEdgeEndpoint + firstElementMirroredIndex - 1);
            } else {
                this.shift = 0;
            }
        } else {
            this.entityFirstUnpinnedIndex = 0;
            this.shift = 0;
        }
    }

    private TwoOptListMove(ListVariableDescriptor<Solution_> variableDescriptor, Object firstEntity, Object secondEntity, int firstEdgeEndpoint, int secondEdgeEndpoint, int entityFirstUnpinnedIndex, int shift) {
        this.variableDescriptor = variableDescriptor;
        this.firstEntity = firstEntity;
        this.secondEntity = secondEntity;
        this.firstEdgeEndpoint = firstEdgeEndpoint;
        this.secondEdgeEndpoint = secondEdgeEndpoint;
        this.entityFirstUnpinnedIndex = entityFirstUnpinnedIndex;
        this.shift = shift;
    }

    @Override
    protected TwoOptListMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        return new TwoOptListMove<Solution_>(this.variableDescriptor, this.firstEntity, this.secondEntity, this.firstEdgeEndpoint, this.secondEdgeEndpoint, this.entityFirstUnpinnedIndex, -this.shift);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        if (this.firstEntity == this.secondEntity) {
            this.doSublistReversal(scoreDirector);
        } else {
            this.doTailSwap(scoreDirector);
        }
    }

    private void doTailSwap(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object firstListVariable = this.variableDescriptor.getValue(this.firstEntity);
        Object secondListVariable = this.variableDescriptor.getValue(this.secondEntity);
        int firstOriginalSize = firstListVariable.size();
        int secondOriginalSize = secondListVariable.size();
        innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, firstOriginalSize);
        innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.secondEntity, this.secondEdgeEndpoint, secondOriginalSize);
        List firstListVariableTail = firstListVariable.subList(this.firstEdgeEndpoint, firstOriginalSize);
        List secondListVariableTail = secondListVariable.subList(this.secondEdgeEndpoint, secondOriginalSize);
        int tailSizeDifference = secondListVariableTail.size() - firstListVariableTail.size();
        ArrayList firstListVariableTailCopy = new ArrayList(firstListVariableTail);
        firstListVariableTail.clear();
        firstListVariable.addAll(secondListVariableTail);
        secondListVariableTail.clear();
        secondListVariable.addAll(firstListVariableTailCopy);
        innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, firstOriginalSize + tailSizeDifference);
        innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.secondEntity, this.secondEdgeEndpoint, secondOriginalSize - tailSizeDifference);
    }

    private void doSublistReversal(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object listVariable = this.variableDescriptor.getValue(this.firstEntity);
        if (this.firstEdgeEndpoint < this.secondEdgeEndpoint) {
            if (this.firstEdgeEndpoint > 0) {
                innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            } else {
                innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, this.entityFirstUnpinnedIndex, listVariable.size());
            }
            if (this.firstEdgeEndpoint == 0 && this.shift > 0) {
                if (this.entityFirstUnpinnedIndex == 0) {
                    Collections.rotate(listVariable, this.shift);
                } else {
                    Collections.rotate(listVariable.subList(this.entityFirstUnpinnedIndex, listVariable.size()), this.shift);
                }
            }
            FlipSublistAction.flipSublist(listVariable, this.entityFirstUnpinnedIndex, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            if (this.firstEdgeEndpoint == 0 && this.shift < 0) {
                if (this.entityFirstUnpinnedIndex == 0) {
                    Collections.rotate(listVariable, this.shift);
                } else {
                    Collections.rotate(listVariable.subList(this.entityFirstUnpinnedIndex, listVariable.size()), this.shift);
                }
            }
            if (this.firstEdgeEndpoint > 0) {
                innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            } else {
                innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, this.entityFirstUnpinnedIndex, listVariable.size());
            }
        } else {
            innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, this.entityFirstUnpinnedIndex, listVariable.size());
            if (this.shift > 0) {
                if (this.entityFirstUnpinnedIndex == 0) {
                    Collections.rotate(listVariable, this.shift);
                } else {
                    Collections.rotate(listVariable.subList(this.entityFirstUnpinnedIndex, listVariable.size()), this.shift);
                }
            }
            FlipSublistAction.flipSublist(listVariable, this.entityFirstUnpinnedIndex, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            if (this.shift < 0) {
                if (this.entityFirstUnpinnedIndex == 0) {
                    Collections.rotate(listVariable, this.shift);
                } else {
                    Collections.rotate(listVariable.subList(this.entityFirstUnpinnedIndex, listVariable.size()), this.shift);
                }
            }
            innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, this.entityFirstUnpinnedIndex, listVariable.size());
        }
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        if (this.firstEntity == this.secondEntity) {
            if (this.shift != 0) {
                return true;
            }
            int chainLength = Math.abs(this.secondEdgeEndpoint - this.firstEdgeEndpoint);
            return chainLength >= 2;
        }
        return true;
    }

    @Override
    public TwoOptListMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new TwoOptListMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.firstEntity), destinationScoreDirector.lookUpWorkingObject(this.secondEntity), this.firstEdgeEndpoint, this.secondEdgeEndpoint, this.entityFirstUnpinnedIndex, this.shift);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return "2-Opt(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<?> getPlanningEntities() {
        if (this.firstEntity == this.secondEntity) {
            return Collections.singleton(this.firstEntity);
        }
        return Set.of(this.firstEntity, this.secondEntity);
    }

    @Override
    public Collection<?> getPlanningValues() {
        if (this.firstEntity == this.secondEntity) {
            Object listVariable = this.variableDescriptor.getValue(this.firstEntity);
            if (this.firstEdgeEndpoint < this.secondEdgeEndpoint) {
                return new ArrayList(listVariable.subList(this.firstEdgeEndpoint, this.secondEdgeEndpoint));
            }
            List firstHalfReversedPath = listVariable.subList(this.firstEdgeEndpoint, listVariable.size());
            List secondHalfReversedPath = listVariable.subList(this.entityFirstUnpinnedIndex, this.secondEdgeEndpoint);
            return CollectionUtils.concat(firstHalfReversedPath, secondHalfReversedPath);
        }
        Object firstListVariable = this.variableDescriptor.getValue(this.firstEntity);
        Object secondListVariable = this.variableDescriptor.getValue(this.secondEntity);
        List firstListVariableTail = firstListVariable.subList(this.firstEdgeEndpoint, firstListVariable.size());
        List secondListVariableTail = secondListVariable.subList(this.secondEdgeEndpoint, secondListVariable.size());
        ArrayList out = new ArrayList(firstListVariableTail.size() + secondListVariableTail.size());
        out.addAll(firstListVariableTail);
        out.addAll(secondListVariableTail);
        return out;
    }

    public Object getFirstEntity() {
        return this.firstEntity;
    }

    public Object getSecondEntity() {
        return this.secondEntity;
    }

    public Object getFirstEdgeEndpoint() {
        return this.firstEdgeEndpoint;
    }

    public Object getSecondEdgeEndpoint() {
        return this.secondEdgeEndpoint;
    }

    public String toString() {
        return "2-Opt(firstEntity=" + this.firstEntity + ", secondEntity=" + this.secondEntity + ", firstEndpointIndex=" + this.firstEdgeEndpoint + ", secondEndpointIndex=" + this.secondEdgeEndpoint + ")";
    }
}

