/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ruin;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.constructionheuristic.DefaultConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.list.LocationInList;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseBuilder;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ruin.ListRuinRecreateUndoMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ruin.RuinedLocation;
import ai.timefold.solver.core.impl.phase.AbstractPhase;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;

public final class ListRuinRecreateMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableStateSupply<Solution_> listVariableStateSupply;
    private final List<Object> ruinedValueList;
    private final Set<Object> affectedEntitySet;
    private final RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder;
    private final SolverScope<Solution_> solverScope;
    private final Map<Object, NavigableSet<RuinedLocation>> entityToOriginalPositionMap;
    private final Map<Object, NavigableSet<RuinedLocation>> entityToNewPositionMap;

    public ListRuinRecreateMove(ListVariableStateSupply<Solution_> listVariableStateSupply, RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder, SolverScope<Solution_> solverScope, List<Object> ruinedValueList, Set<Object> affectedEntitySet) {
        this.listVariableStateSupply = listVariableStateSupply;
        this.constructionHeuristicPhaseBuilder = constructionHeuristicPhaseBuilder;
        this.solverScope = solverScope;
        this.ruinedValueList = ruinedValueList;
        this.affectedEntitySet = affectedEntitySet;
        this.entityToOriginalPositionMap = CollectionUtils.newIdentityHashMap(affectedEntitySet.size());
        this.entityToNewPositionMap = CollectionUtils.newIdentityHashMap(affectedEntitySet.size());
    }

    @Override
    protected Move<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        return new ListRuinRecreateUndoMove(this, this.listVariableStateSupply.getSourceVariableDescriptor(), this.entityToNewPositionMap, this.entityToOriginalPositionMap);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        this.entityToNewPositionMap.clear();
        this.entityToOriginalPositionMap.clear();
        VariableDescriptorAwareScoreDirector innerScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        for (Object object : this.ruinedValueList) {
            LocationInList location = (LocationInList)this.listVariableStateSupply.getLocationInList(object);
            this.entityToOriginalPositionMap.computeIfAbsent(location.entity(), ignored -> new TreeSet()).add(new RuinedLocation(object, location.index()));
        }
        VariableDescriptor listVariableDescriptor = this.listVariableStateSupply.getSourceVariableDescriptor();
        for (Map.Entry<Object, NavigableSet<RuinedLocation>> entry : this.entityToOriginalPositionMap.entrySet()) {
            Object entity = entry.getKey();
            innerScoreDirector.beforeListVariableChanged(listVariableDescriptor, entity, ((ListVariableDescriptor)listVariableDescriptor).getFirstUnpinnedIndex(entity), ((ListVariableDescriptor)listVariableDescriptor).getListSize(entity));
            for (RuinedLocation position : entry.getValue().descendingSet()) {
                innerScoreDirector.beforeListVariableElementUnassigned(listVariableDescriptor, position.ruinedValue());
                ((ListVariableDescriptor)listVariableDescriptor).removeElement(entity, position.index());
                innerScoreDirector.afterListVariableElementUnassigned(listVariableDescriptor, position.ruinedValue());
            }
            innerScoreDirector.afterListVariableChanged(listVariableDescriptor, entity, ((ListVariableDescriptor)listVariableDescriptor).getFirstUnpinnedIndex(entity), ((ListVariableDescriptor)listVariableDescriptor).getListSize(entity));
        }
        scoreDirector.triggerVariableListeners();
        AbstractPhase abstractPhase = this.constructionHeuristicPhaseBuilder.withElementsToRecreate(this.ruinedValueList).build();
        abstractPhase.setSolver(this.solverScope.getSolver());
        ((DefaultConstructionHeuristicPhase)abstractPhase).solvingStarted(this.solverScope);
        ((DefaultConstructionHeuristicPhase)abstractPhase).solve(this.solverScope);
        ((DefaultConstructionHeuristicPhase)abstractPhase).solvingEnded(this.solverScope);
        scoreDirector.triggerVariableListeners();
        for (Object ruinedValue : this.ruinedValueList) {
            LocationInList location = (LocationInList)this.listVariableStateSupply.getLocationInList(ruinedValue);
            this.entityToNewPositionMap.computeIfAbsent(location.entity(), ignored -> new TreeSet()).add(new RuinedLocation(ruinedValue, location.index()));
        }
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return this.affectedEntitySet;
    }

    @Override
    public Collection<?> getPlanningValues() {
        return this.ruinedValueList;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return true;
    }

    public String toString() {
        return "ListRuinMove{values=" + this.ruinedValueList + ", newLocationsByEntity=" + (!this.entityToNewPositionMap.isEmpty() ? this.entityToNewPositionMap : "?") + "}";
    }
}

