/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.chained;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.List;
import java.util.Objects;

public final class SubChain {
    private final List<Object> entityList;

    public SubChain(List<Object> entityList) {
        this.entityList = entityList;
    }

    public List<Object> getEntityList() {
        return this.entityList;
    }

    public Object getFirstEntity() {
        if (this.entityList.isEmpty()) {
            return null;
        }
        return this.entityList.get(0);
    }

    public Object getLastEntity() {
        if (this.entityList.isEmpty()) {
            return null;
        }
        return this.entityList.get(this.entityList.size() - 1);
    }

    public int getSize() {
        return this.entityList.size();
    }

    public SubChain reverse() {
        return new SubChain(CollectionUtils.copy(this.entityList, true));
    }

    public SubChain subChain(int fromIndex, int toIndex) {
        return new SubChain(this.entityList.subList(fromIndex, toIndex));
    }

    public SubChain rebase(ScoreDirector<?> destinationScoreDirector) {
        return new SubChain(AbstractMove.rebaseList(this.entityList, destinationScoreDirector));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SubChain subChain = (SubChain)other;
        return Objects.equals(this.entityList, subChain.entityList);
    }

    public int hashCode() {
        return Objects.hash(this.entityList);
    }

    public String toString() {
        return this.entityList.toString();
    }

    public String toDottedString() {
        return "[" + this.getFirstEntity() + ".." + this.getLastEntity() + "]";
    }
}

