/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch.decider.acceptor.greatdeluge;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchMoveScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;

public class GreatDelugeAcceptor<Solution_>
extends AbstractAcceptor<Solution_> {
    private Score initialWaterLevel;
    private Score waterLevelIncrementScore;
    private Double waterLevelIncrementRatio;
    private Score startingWaterLevel = null;
    private Score currentWaterLevel = null;
    private Double currentWaterLevelRatio = null;

    public Score getWaterLevelIncrementScore() {
        return this.waterLevelIncrementScore;
    }

    public void setWaterLevelIncrementScore(Score waterLevelIncrementScore) {
        this.waterLevelIncrementScore = waterLevelIncrementScore;
    }

    public Score getInitialWaterLevel() {
        return this.initialWaterLevel;
    }

    public void setInitialWaterLevel(Score initialLevel) {
        this.initialWaterLevel = initialLevel;
    }

    public Double getWaterLevelIncrementRatio() {
        return this.waterLevelIncrementRatio;
    }

    public void setWaterLevelIncrementRatio(Double waterLevelIncrementRatio) {
        this.waterLevelIncrementRatio = waterLevelIncrementRatio;
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        Score score = this.startingWaterLevel = this.initialWaterLevel != null ? this.initialWaterLevel : phaseScope.getBestScore();
        if (this.waterLevelIncrementRatio != null) {
            this.currentWaterLevelRatio = 0.0;
        }
        this.currentWaterLevel = this.startingWaterLevel;
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.startingWaterLevel = null;
        if (this.waterLevelIncrementRatio != null) {
            this.currentWaterLevelRatio = null;
        }
        this.currentWaterLevel = null;
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(this.currentWaterLevel) >= 0) {
            return true;
        }
        Score<?> lastStepScore = ((LocalSearchPhaseScope)((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
        return moveScore.compareTo(lastStepScore) > 0;
    }

    @Override
    public void stepEnded(LocalSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        if (this.waterLevelIncrementScore != null) {
            this.currentWaterLevel = this.currentWaterLevel.add(this.waterLevelIncrementScore);
        } else {
            this.currentWaterLevelRatio = this.currentWaterLevelRatio + this.waterLevelIncrementRatio;
            this.currentWaterLevel = this.startingWaterLevel.add(this.startingWaterLevel.abs().multiply(this.currentWaterLevelRatio));
        }
    }
}

