/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.buildin;

import ai.timefold.solver.core.api.score.buildin.bendable.BendableScore;
import ai.timefold.solver.core.config.score.trend.InitializingScoreTrendLevel;
import ai.timefold.solver.core.impl.score.definition.AbstractBendableScoreDefinition;
import ai.timefold.solver.core.impl.score.trend.InitializingScoreTrend;
import java.util.Arrays;
import java.util.stream.IntStream;

public class BendableScoreDefinition
extends AbstractBendableScoreDefinition<BendableScore> {
    public BendableScoreDefinition(int hardLevelsSize, int softLevelsSize) {
        super(hardLevelsSize, softLevelsSize);
    }

    @Override
    public Class<BendableScore> getScoreClass() {
        return BendableScore.class;
    }

    @Override
    public BendableScore getZeroScore() {
        return BendableScore.zero(this.hardLevelsSize, this.softLevelsSize);
    }

    @Override
    public final BendableScore getOneSoftestScore() {
        return BendableScore.ofSoft(this.hardLevelsSize, this.softLevelsSize, this.softLevelsSize - 1, 1);
    }

    @Override
    public BendableScore parseScore(String scoreString) {
        BendableScore score = BendableScore.parseScore(scoreString);
        if (score.hardLevelsSize() != this.hardLevelsSize) {
            throw new IllegalArgumentException("The scoreString (" + scoreString + ") for the scoreClass (" + BendableScore.class.getSimpleName() + ") doesn't follow the correct pattern: the hardLevelsSize (" + score.hardLevelsSize() + ") doesn't match the scoreDefinition's hardLevelsSize (" + this.hardLevelsSize + ").");
        }
        if (score.softLevelsSize() != this.softLevelsSize) {
            throw new IllegalArgumentException("The scoreString (" + scoreString + ") for the scoreClass (" + BendableScore.class.getSimpleName() + ") doesn't follow the correct pattern: the softLevelsSize (" + score.softLevelsSize() + ") doesn't match the scoreDefinition's softLevelsSize (" + this.softLevelsSize + ").");
        }
        return score;
    }

    @Override
    public BendableScore fromLevelNumbers(int initScore, Number[] levelNumbers) {
        if (levelNumbers.length != this.getLevelsSize()) {
            throw new IllegalStateException("The levelNumbers (" + Arrays.toString(levelNumbers) + ")'s length (" + levelNumbers.length + ") must equal the levelSize (" + this.getLevelsSize() + ").");
        }
        int[] hardScores = new int[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = (Integer)levelNumbers[i];
        }
        int[] softScores = new int[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = (Integer)levelNumbers[this.hardLevelsSize + i];
        }
        return BendableScore.ofUninitialized(initScore, hardScores, softScores);
    }

    public BendableScore createScore(int ... scores) {
        return this.createScoreUninitialized(0, scores);
    }

    public BendableScore createScoreUninitialized(int initScore, int ... scores) {
        int levelsSize = this.hardLevelsSize + this.softLevelsSize;
        if (scores.length != levelsSize) {
            throw new IllegalArgumentException("The scores (" + Arrays.toString(scores) + ")'s length (" + scores.length + ") is not levelsSize (" + levelsSize + ").");
        }
        return BendableScore.ofUninitialized(initScore, Arrays.copyOfRange(scores, 0, this.hardLevelsSize), Arrays.copyOfRange(scores, this.hardLevelsSize, levelsSize));
    }

    @Override
    public BendableScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, BendableScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.trendLevels();
        int[] hardScores = new int[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = trendLevels[i] == InitializingScoreTrendLevel.ONLY_DOWN ? score.hardScore(i) : Integer.MAX_VALUE;
        }
        int[] softScores = new int[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = trendLevels[this.hardLevelsSize + i] == InitializingScoreTrendLevel.ONLY_DOWN ? score.softScore(i) : Integer.MAX_VALUE;
        }
        return BendableScore.ofUninitialized(0, hardScores, softScores);
    }

    @Override
    public BendableScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, BendableScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.trendLevels();
        int[] hardScores = new int[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = trendLevels[i] == InitializingScoreTrendLevel.ONLY_UP ? score.hardScore(i) : Integer.MIN_VALUE;
        }
        int[] softScores = new int[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = trendLevels[this.hardLevelsSize + i] == InitializingScoreTrendLevel.ONLY_UP ? score.softScore(i) : Integer.MIN_VALUE;
        }
        return BendableScore.ofUninitialized(0, hardScores, softScores);
    }

    @Override
    public BendableScore divideBySanitizedDivisor(BendableScore dividend, BendableScore divisor) {
        int dividendInitScore = dividend.initScore();
        int divisorInitScore = BendableScoreDefinition.sanitize(divisor.initScore());
        int[] hardScores = new int[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = BendableScoreDefinition.divide(dividend.hardScore(i), BendableScoreDefinition.sanitize(divisor.hardScore(i)));
        }
        int[] softScores = new int[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = BendableScoreDefinition.divide(dividend.softScore(i), BendableScoreDefinition.sanitize(divisor.softScore(i)));
        }
        int[] levels = IntStream.concat(Arrays.stream(hardScores), Arrays.stream(softScores)).toArray();
        return this.createScoreUninitialized(BendableScoreDefinition.divide(dividendInitScore, divisorInitScore), levels);
    }

    @Override
    public Class<?> getNumericType() {
        return Integer.TYPE;
    }
}

