/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.buildin;

import ai.timefold.solver.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import ai.timefold.solver.core.config.score.trend.InitializingScoreTrendLevel;
import ai.timefold.solver.core.impl.score.definition.AbstractScoreDefinition;
import ai.timefold.solver.core.impl.score.trend.InitializingScoreTrend;
import java.util.Arrays;

public class HardMediumSoftScoreDefinition
extends AbstractScoreDefinition<HardMediumSoftScore> {
    public HardMediumSoftScoreDefinition() {
        super(new String[]{"hard score", "medium score", "soft score"});
    }

    @Override
    public int getLevelsSize() {
        return 3;
    }

    @Override
    public int getFeasibleLevelsSize() {
        return 1;
    }

    @Override
    public Class<HardMediumSoftScore> getScoreClass() {
        return HardMediumSoftScore.class;
    }

    @Override
    public HardMediumSoftScore getZeroScore() {
        return HardMediumSoftScore.ZERO;
    }

    @Override
    public HardMediumSoftScore getOneSoftestScore() {
        return HardMediumSoftScore.ONE_SOFT;
    }

    @Override
    public HardMediumSoftScore parseScore(String scoreString) {
        return HardMediumSoftScore.parseScore(scoreString);
    }

    @Override
    public HardMediumSoftScore fromLevelNumbers(int initScore, Number[] levelNumbers) {
        if (levelNumbers.length != this.getLevelsSize()) {
            throw new IllegalStateException("The levelNumbers (" + Arrays.toString(levelNumbers) + ")'s length (" + levelNumbers.length + ") must equal the levelSize (" + this.getLevelsSize() + ").");
        }
        return HardMediumSoftScore.ofUninitialized(initScore, (Integer)levelNumbers[0], (Integer)levelNumbers[1], (Integer)levelNumbers[2]);
    }

    @Override
    public HardMediumSoftScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, HardMediumSoftScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.trendLevels();
        return HardMediumSoftScore.ofUninitialized(0, trendLevels[0] == InitializingScoreTrendLevel.ONLY_DOWN ? score.hardScore() : Integer.MAX_VALUE, trendLevels[1] == InitializingScoreTrendLevel.ONLY_DOWN ? score.mediumScore() : Integer.MAX_VALUE, trendLevels[2] == InitializingScoreTrendLevel.ONLY_DOWN ? score.softScore() : Integer.MAX_VALUE);
    }

    @Override
    public HardMediumSoftScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, HardMediumSoftScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.trendLevels();
        return HardMediumSoftScore.ofUninitialized(0, trendLevels[0] == InitializingScoreTrendLevel.ONLY_UP ? score.hardScore() : Integer.MIN_VALUE, trendLevels[1] == InitializingScoreTrendLevel.ONLY_UP ? score.mediumScore() : Integer.MIN_VALUE, trendLevels[2] == InitializingScoreTrendLevel.ONLY_UP ? score.softScore() : Integer.MIN_VALUE);
    }

    @Override
    public HardMediumSoftScore divideBySanitizedDivisor(HardMediumSoftScore dividend, HardMediumSoftScore divisor) {
        int dividendInitScore = dividend.initScore();
        int divisorInitScore = HardMediumSoftScoreDefinition.sanitize(divisor.initScore());
        int dividendHardScore = dividend.hardScore();
        int divisorHardScore = HardMediumSoftScoreDefinition.sanitize(divisor.hardScore());
        int dividendMediumScore = dividend.mediumScore();
        int divisorMediumScore = HardMediumSoftScoreDefinition.sanitize(divisor.mediumScore());
        int dividendSoftScore = dividend.softScore();
        int divisorSoftScore = HardMediumSoftScoreDefinition.sanitize(divisor.softScore());
        return this.fromLevelNumbers(HardMediumSoftScoreDefinition.divide(dividendInitScore, divisorInitScore), new Number[]{HardMediumSoftScoreDefinition.divide(dividendHardScore, divisorHardScore), HardMediumSoftScoreDefinition.divide(dividendMediumScore, divisorMediumScore), HardMediumSoftScoreDefinition.divide(dividendSoftScore, divisorSoftScore)});
    }

    @Override
    public Class<?> getNumericType() {
        return Integer.TYPE;
    }
}

