/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.api.domain.variable.VariableListener;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.ConstraintAnalysis;
import ai.timefold.solver.core.api.score.analysis.MatchAnalysis;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.lookup.LookUpManager;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.support.VariableListenerSupport;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.SolutionTracker;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.phase.scope.SolverLifecyclePoint;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorCache;
import ai.timefold.solver.core.impl.solver.exception.UndoScoreCorruptionException;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirector<Solution_, Score_ extends Score<Score_>, Factory_ extends AbstractScoreDirectorFactory<Solution_, Score_>>
implements InnerScoreDirector<Solution_, Score_>,
Cloneable {
    private static final int CONSTRAINT_MATCH_DISPLAY_LIMIT = 8;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean lookUpEnabled;
    private final LookUpManager lookUpManager;
    private final boolean expectShadowVariablesInCorrectState;
    protected final Factory_ scoreDirectorFactory;
    private final VariableDescriptorCache<Solution_> variableDescriptorCache;
    protected final VariableListenerSupport<Solution_> variableListenerSupport;
    protected final boolean constraintMatchEnabledPreference;
    private long workingEntityListRevision = 0L;
    private int workingGenuineEntityCount = 0;
    private boolean allChangesWillBeUndoneBeforeStepEnds = false;
    private long calculationCount = 0L;
    protected Solution_ workingSolution;
    private int workingInitScore = 0;
    private String undoMoveText;
    private final boolean trackingWorkingSolution;
    private final SolutionTracker<Solution_> solutionTracker;

    protected AbstractScoreDirector(Factory_ scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference, boolean expectShadowVariablesInCorrectState) {
        SolutionDescriptor solutionDescriptor = ((AbstractScoreDirectorFactory)scoreDirectorFactory).getSolutionDescriptor();
        this.lookUpEnabled = lookUpEnabled;
        this.lookUpManager = lookUpEnabled ? new LookUpManager(solutionDescriptor.getLookUpStrategyResolver()) : null;
        this.expectShadowVariablesInCorrectState = expectShadowVariablesInCorrectState;
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.variableDescriptorCache = new VariableDescriptorCache(solutionDescriptor);
        this.variableListenerSupport = VariableListenerSupport.create(this);
        this.variableListenerSupport.linkVariableListeners();
        this.constraintMatchEnabledPreference = constraintMatchEnabledPreference;
        if (((AbstractScoreDirectorFactory)scoreDirectorFactory).isTrackingWorkingSolution()) {
            this.solutionTracker = new SolutionTracker<Solution_>(this.getSolutionDescriptor(), this.getSupplyManager());
            this.trackingWorkingSolution = true;
        } else {
            this.solutionTracker = null;
            this.trackingWorkingSolution = false;
        }
    }

    public Factory_ getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
    }

    @Override
    public ScoreDefinition<Score_> getScoreDefinition() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getScoreDefinition();
    }

    @Override
    public VariableDescriptorCache<Solution_> getVariableDescriptorCache() {
        return this.variableDescriptorCache;
    }

    @Override
    public boolean expectShadowVariablesInCorrectState() {
        return this.expectShadowVariablesInCorrectState;
    }

    @Override
    public Solution_ getWorkingSolution() {
        return this.workingSolution;
    }

    protected int getWorkingInitScore() {
        return this.workingInitScore;
    }

    @Override
    public long getWorkingEntityListRevision() {
        return this.workingEntityListRevision;
    }

    @Override
    public int getWorkingGenuineEntityCount() {
        return this.workingGenuineEntityCount;
    }

    @Override
    public void setAllChangesWillBeUndoneBeforeStepEnds(boolean allChangesWillBeUndoneBeforeStepEnds) {
        this.allChangesWillBeUndoneBeforeStepEnds = allChangesWillBeUndoneBeforeStepEnds;
    }

    @Override
    public long getCalculationCount() {
        return this.calculationCount;
    }

    @Override
    public void resetCalculationCount() {
        this.calculationCount = 0L;
    }

    @Override
    public void incrementCalculationCount() {
        ++this.calculationCount;
    }

    @Override
    public SupplyManager getSupplyManager() {
        return this.variableListenerSupport;
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        this.workingSolution = Objects.requireNonNull(workingSolution);
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        Consumer<Object> visitor = null;
        if (this.lookUpEnabled) {
            this.lookUpManager.reset();
            visitor = this.lookUpManager::addWorkingObject;
            solutionDescriptor.visitAllProblemFacts(workingSolution, visitor);
        }
        Consumer<Object> entityValidator = entity -> ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).validateEntity(this, entity);
        visitor = visitor == null ? entityValidator : visitor.andThen(entityValidator);
        SolutionDescriptor.SolutionInitializationStatistics initializationStatistics = solutionDescriptor.computeInitializationStatistics(workingSolution, visitor);
        this.setWorkingEntityListDirty();
        this.workingInitScore = -(initializationStatistics.unassignedValueCount() + initializationStatistics.uninitializedVariableCount());
        this.assertInitScoreZeroOrLess();
        this.workingGenuineEntityCount = initializationStatistics.genuineEntityCount();
        this.variableListenerSupport.resetWorkingSolution();
    }

    private void assertInitScoreZeroOrLess() {
        if (this.workingInitScore > 0) {
            throw new IllegalStateException("workingInitScore > 0 (%d).\nMaybe a custom move is removing more entities than were ever added?\n".formatted(this.workingInitScore));
        }
    }

    @Override
    public Score_ doAndProcessMove(Move<Solution_> move, boolean assertMoveScoreFromScratch, Consumer<Score_> moveProcessor) {
        if (this.trackingWorkingSolution) {
            this.solutionTracker.setBeforeMoveSolution(this.workingSolution);
        }
        Move<Solution_> undoMove = move.doMove(this);
        Object score = this.calculateScore();
        if (assertMoveScoreFromScratch) {
            this.undoMoveText = undoMove.toString();
            if (this.trackingWorkingSolution) {
                this.solutionTracker.setAfterMoveSolution(this.workingSolution);
            }
            this.assertWorkingScoreFromScratch(score, move);
        }
        if (moveProcessor != null) {
            moveProcessor.accept(score);
        }
        undoMove.doMoveOnly(this);
        return score;
    }

    @Override
    public boolean isWorkingEntityListDirty(long expectedWorkingEntityListRevision) {
        return this.workingEntityListRevision != expectedWorkingEntityListRevision;
    }

    protected void setWorkingEntityListDirty() {
        ++this.workingEntityListRevision;
    }

    @Override
    public Solution_ cloneSolution(Solution_ originalSolution) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        Object originalScore = solutionDescriptor.getScore(originalSolution);
        Solution_ cloneSolution = solutionDescriptor.getSolutionCloner().cloneSolution(originalSolution);
        Object cloneScore = solutionDescriptor.getScore(cloneSolution);
        if (((AbstractScoreDirectorFactory)this.scoreDirectorFactory).isAssertClonedSolution()) {
            if (!Objects.equals(originalScore, cloneScore)) {
                throw new IllegalStateException("Cloning corruption: the original's score (" + originalScore + ") is different from the clone's score (" + cloneScore + ").\nCheck the " + SolutionCloner.class.getSimpleName() + ".");
            }
            IdentityHashMap originalEntityMap = new IdentityHashMap();
            solutionDescriptor.visitAllEntities(originalSolution, originalEntity -> originalEntityMap.put(originalEntity, null));
            solutionDescriptor.visitAllEntities(cloneSolution, cloneEntity -> {
                if (originalEntityMap.containsKey(cloneEntity)) {
                    throw new IllegalStateException("Cloning corruption: the same entity (" + cloneEntity + ") is present in both the original and the clone.\nSo when a planning variable in the original solution changes, the cloned solution will change too.\nCheck the " + SolutionCloner.class.getSimpleName() + ".");
                }
            });
        }
        return cloneSolution;
    }

    @Override
    public void triggerVariableListeners() {
        this.variableListenerSupport.triggerVariableListenersInNotificationQueues();
    }

    @Override
    public void forceTriggerVariableListeners() {
        this.variableListenerSupport.forceTriggerAllVariableListeners(this.getWorkingSolution());
    }

    protected void setCalculatedScore(Score_ score) {
        this.getSolutionDescriptor().setScore(this.workingSolution, score);
        ++this.calculationCount;
    }

    @Deprecated(forRemoval=true, since="1.14.0")
    public AbstractScoreDirector<Solution_, Score_, Factory_> clone() {
        throw new UnsupportedOperationException("Cloning score directors is not supported.");
    }

    @Override
    public InnerScoreDirector<Solution_, Score_> createChildThreadScoreDirector(ChildThreadType childThreadType) {
        if (childThreadType == ChildThreadType.PART_THREAD) {
            AbstractScoreDirector childThreadScoreDirector = (AbstractScoreDirector)this.scoreDirectorFactory.buildDerivedScoreDirector(this.lookUpEnabled, this.constraintMatchEnabledPreference);
            childThreadScoreDirector.calculationCount = this.calculationCount;
            return childThreadScoreDirector;
        }
        if (childThreadType == ChildThreadType.MOVE_THREAD) {
            AbstractScoreDirector childThreadScoreDirector = (AbstractScoreDirector)this.scoreDirectorFactory.buildDerivedScoreDirector(true, this.constraintMatchEnabledPreference);
            childThreadScoreDirector.setWorkingSolution(this.cloneWorkingSolution());
            return childThreadScoreDirector;
        }
        throw new IllegalStateException("The childThreadType (" + childThreadType + ") is not implemented.");
    }

    @Override
    public void close() {
        this.workingSolution = null;
        this.workingInitScore = 0;
        if (this.lookUpEnabled) {
            this.lookUpManager.reset();
        }
        this.variableListenerSupport.close();
    }

    @Override
    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.variableListenerSupport.beforeEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.workingInitScore -= entityDescriptor.countUninitializedVariables(entity);
        if (entityDescriptor.isGenuine()) {
            ++this.workingGenuineEntityCount;
        }
        if (this.lookUpEnabled) {
            this.lookUpManager.addWorkingObject(entity);
        }
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        if (variableDescriptor.isGenuineAndUninitialized(entity)) {
            ++this.workingInitScore;
        }
        this.assertInitScoreZeroOrLess();
        this.variableListenerSupport.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        if (variableDescriptor.isGenuineAndUninitialized(entity)) {
            --this.workingInitScore;
        }
    }

    @Override
    public void changeVariableFacade(VariableDescriptor<Solution_> variableDescriptor, Object entity, Object newValue) {
        this.beforeVariableChanged(variableDescriptor, entity);
        variableDescriptor.setValue(entity, newValue);
        this.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void beforeListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
    }

    @Override
    public void afterListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        if (!variableDescriptor.allowsUnassignedValues()) {
            ++this.workingInitScore;
            this.assertInitScoreZeroOrLess();
        }
    }

    @Override
    public void beforeListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
    }

    @Override
    public void afterListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        if (!variableDescriptor.allowsUnassignedValues()) {
            --this.workingInitScore;
        }
        this.variableListenerSupport.afterElementUnassigned(variableDescriptor, element);
    }

    @Override
    public void beforeListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        if (variableDescriptor.isElementPinned(this.getWorkingSolution(), entity, fromIndex)) {
            throw new IllegalStateException("Attempting to change list variable (%s) on an entity (%s) in range [%d, %d), which is partially or entirely pinned.\nThis is most likely a bug in a move.\nMaybe you are using an improperly implemented custom move?".formatted(variableDescriptor, entity, fromIndex, toIndex));
        }
        this.variableListenerSupport.beforeListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        this.variableListenerSupport.afterListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.workingInitScore += entityDescriptor.countUninitializedVariables(entity);
        this.assertInitScoreZeroOrLess();
        this.variableListenerSupport.beforeEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (entityDescriptor.isGenuine()) {
            --this.workingGenuineEntityCount;
        }
        if (this.lookUpEnabled) {
            this.lookUpManager.removeWorkingObject(entity);
        }
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        if (this.lookUpEnabled) {
            this.lookUpManager.addWorkingObject(problemFact);
        }
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public void beforeProblemPropertyChanged(Object problemFactOrEntity) {
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        if (this.isConstraintConfiguration(problemFactOrEntity)) {
            this.setWorkingSolution(this.workingSolution);
        } else {
            this.variableListenerSupport.resetWorkingSolution();
        }
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
        if (this.isConstraintConfiguration(problemFact)) {
            throw new IllegalStateException("Attempted to remove constraint configuration (" + problemFact + ") from solution (" + this.workingSolution + ").\nMaybe use before/afterProblemPropertyChanged(...) instead.");
        }
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        if (this.lookUpEnabled) {
            this.lookUpManager.removeWorkingObject(problemFact);
        }
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public <E> E lookUpWorkingObject(E externalObject) {
        if (!this.lookUpEnabled) {
            throw new IllegalStateException("When lookUpEnabled (" + this.lookUpEnabled + ") is disabled in the constructor, this method should not be called.");
        }
        return this.lookUpManager.lookUpWorkingObject(externalObject);
    }

    @Override
    public <E> E lookUpWorkingObjectOrReturnNull(E externalObject) {
        if (!this.lookUpEnabled) {
            throw new IllegalStateException("When lookUpEnabled (" + this.lookUpEnabled + ") is disabled in the constructor, this method should not be called.");
        }
        return this.lookUpManager.lookUpWorkingObjectOrReturnNull(externalObject);
    }

    @Override
    public void assertExpectedWorkingScore(Score_ expectedWorkingScore, Object completedAction) {
        Object workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            throw new IllegalStateException("Score corruption (" + expectedWorkingScore.subtract(workingScore).toShortString() + "): the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore (" + workingScore + ") after completedAction (" + completedAction + ").");
        }
    }

    @Override
    public void assertShadowVariablesAreNotStale(Score_ expectedWorkingScore, Object completedAction) {
        String violationMessage = this.variableListenerSupport.createShadowVariablesViolationMessage();
        if (violationMessage != null) {
            throw new IllegalStateException(VariableListener.class.getSimpleName() + " corruption after completedAction (" + completedAction + "):\n" + violationMessage);
        }
        Object workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            this.assertWorkingScoreFromScratch(workingScore, "assertShadowVariablesAreNotStale(" + expectedWorkingScore + ", " + completedAction + ")");
            throw new IllegalStateException("Impossible " + VariableListener.class.getSimpleName() + " corruption (" + expectedWorkingScore.subtract(workingScore).toShortString() + "): the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore (" + workingScore + ") after all " + VariableListener.class.getSimpleName() + "s were triggered without changes to the genuine variables after completedAction (" + completedAction + ").\nBut all the shadow variable values are still the same, so this is impossible.\nMaybe run with " + EnvironmentMode.TRACKED_FULL_ASSERT + " if you aren't already, to fail earlier.");
        }
    }

    protected String buildShadowVariableAnalysis(boolean predicted) {
        String workingLabel;
        String violationMessage = this.variableListenerSupport.createShadowVariablesViolationMessage();
        String string = workingLabel = predicted ? "working" : "corrupted";
        if (violationMessage == null) {
            return "Shadow variable corruption in the " + workingLabel + " scoreDirector:\n  None";
        }
        return "Shadow variable corruption in the " + workingLabel + " scoreDirector:\n" + violationMessage + "  Maybe there is a bug in the " + VariableListener.class.getSimpleName() + " of those shadow variable(s).";
    }

    @Override
    public void assertWorkingScoreFromScratch(Score_ workingScore, Object completedAction) {
        this.assertScoreFromScratch(workingScore, completedAction, false);
    }

    @Override
    public void assertPredictedScoreFromScratch(Score_ workingScore, Object completedAction) {
        this.assertScoreFromScratch(workingScore, completedAction, true);
    }

    private void assertScoreFromScratch(Score_ score, Object completedAction, boolean predicted) {
        InnerScoreDirectorFactory assertionScoreDirectorFactory = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getAssertionScoreDirectorFactory();
        if (assertionScoreDirectorFactory == null) {
            assertionScoreDirectorFactory = this.scoreDirectorFactory;
        }
        try (InnerScoreDirector uncorruptedScoreDirector = assertionScoreDirectorFactory.buildDerivedScoreDirector(false, true);){
            uncorruptedScoreDirector.setWorkingSolution(this.workingSolution);
            Object uncorruptedScore = uncorruptedScoreDirector.calculateScore();
            if (!score.equals(uncorruptedScore)) {
                String scoreCorruptionAnalysis = this.buildScoreCorruptionAnalysis(uncorruptedScoreDirector, predicted);
                String shadowVariableAnalysis = this.buildShadowVariableAnalysis(predicted);
                throw new IllegalStateException("Score corruption (" + score.subtract(uncorruptedScore).toShortString() + "): the " + (predicted ? "predictedScore" : "workingScore") + " (" + score + ") is not the uncorruptedScore (" + uncorruptedScore + ") after completedAction (" + completedAction + "):\n" + scoreCorruptionAnalysis + "\n" + shadowVariableAnalysis);
            }
        }
    }

    @Override
    public void assertExpectedUndoMoveScore(Move<Solution_> move, Score_ beforeMoveScore, SolverLifecyclePoint executionPoint) {
        Score_ undoScore = this.calculateScore();
        if (!undoScore.equals(beforeMoveScore)) {
            this.logger.trace("        Corruption detected. Diagnosing...");
            if (this.trackingWorkingSolution) {
                this.solutionTracker.setAfterUndoSolution(this.workingSolution);
            }
            this.assertWorkingScoreFromScratch(undoScore, this.undoMoveText);
            this.assertShadowVariablesAreNotStale(undoScore, this.undoMoveText);
            String corruptionDiagnosis = "";
            if (this.trackingWorkingSolution) {
                this.variableListenerSupport.forceTriggerAllVariableListeners(this.workingSolution);
                this.solutionTracker.setUndoFromScratchSolution(this.workingSolution);
                this.solutionTracker.restoreBeforeSolution();
                this.variableListenerSupport.forceTriggerAllVariableListeners(this.workingSolution);
                this.solutionTracker.setBeforeFromScratchSolution(this.workingSolution);
                corruptionDiagnosis = this.solutionTracker.buildScoreCorruptionMessage();
            }
            String scoreDifference = undoScore.subtract(beforeMoveScore).toShortString();
            String corruptionMessage = "UndoMove corruption (%s):\n   the beforeMoveScore (%s) is not the undoScore (%s),\n   which is the uncorruptedScore (%s) of the workingSolution.\n\nCorruption diagnosis:\n%s\n\n1) Enable EnvironmentMode %s (if you haven't already)\n   to fail-faster in case of a score corruption or variable listener corruption.\n   Let the solver run until it reaches the same point in its lifecycle (%s),\n   even though it may take a very long time.\n   If the solver throws an exception before reaching that point,\n   there may be yet another problem that needs to be fixed.\n\n2) If you use custom moves, check the Move.createUndoMove(...) method of the custom move class (%s).\n   The move (%s) might have a corrupted undoMove (%s).\n\n3) If you use custom %ss,\n   check them for shadow variables that are used by score constraints\n   that could cause the scoreDifference (%s).".formatted(new Object[]{scoreDifference, beforeMoveScore, undoScore, undoScore, corruptionDiagnosis, EnvironmentMode.TRACKED_FULL_ASSERT, executionPoint, move.getClass().getSimpleName(), move, this.undoMoveText, VariableListener.class.getSimpleName(), scoreDifference});
            if (this.trackingWorkingSolution) {
                throw new UndoScoreCorruptionException(corruptionMessage, this.solutionTracker.getBeforeMoveSolution(), this.solutionTracker.getAfterMoveSolution(), this.solutionTracker.getAfterUndoSolution());
            }
            throw new IllegalStateException(corruptionMessage);
        }
    }

    protected String buildScoreCorruptionAnalysis(InnerScoreDirector<Solution_, Score_> uncorruptedScoreDirector, boolean predicted) {
        if (!this.isConstraintMatchEnabled() || !uncorruptedScoreDirector.isConstraintMatchEnabled()) {
            return "Score corruption analysis could not be generated because either corrupted constraintMatchEnabled (%s) or uncorrupted constraintMatchEnabled (%s) is disabled.\n  Check your score constraints manually.".formatted(this.constraintMatchEnabledPreference, uncorruptedScoreDirector.isConstraintMatchEnabled());
        }
        ScoreAnalysis corruptedAnalysis = this.buildScoreAnalysis(true, InnerScoreDirector.ScoreAnalysisMode.SCORE_CORRUPTION);
        ScoreAnalysis<Score_> uncorruptedAnalysis = uncorruptedScoreDirector.buildScoreAnalysis(true, InnerScoreDirector.ScoreAnalysisMode.SCORE_CORRUPTION);
        LinkedHashSet<MatchAnalysis<Score_>> excessSet = new LinkedHashSet<MatchAnalysis<Score_>>();
        LinkedHashSet<MatchAnalysis<Score_>> missingSet = new LinkedHashSet<MatchAnalysis<Score_>>();
        uncorruptedAnalysis.constraintMap().forEach((constraintRef, uncorruptedConstraintAnalysis) -> {
            ConstraintAnalysis corruptedConstraintAnalysis = corruptedAnalysis.constraintMap().get(constraintRef);
            if (corruptedConstraintAnalysis == null || corruptedConstraintAnalysis.matches().isEmpty()) {
                missingSet.addAll(uncorruptedConstraintAnalysis.matches());
                return;
            }
            this.updateExcessAndMissingConstraintMatches(uncorruptedConstraintAnalysis.matches(), corruptedConstraintAnalysis.matches(), excessSet, missingSet);
        });
        corruptedAnalysis.constraintMap().forEach((constraintRef, corruptedConstraintAnalysis) -> {
            ConstraintAnalysis uncorruptedConstraintAnalysis = uncorruptedAnalysis.constraintMap().get(constraintRef);
            if (uncorruptedConstraintAnalysis == null || uncorruptedConstraintAnalysis.matches().isEmpty()) {
                excessSet.addAll(corruptedConstraintAnalysis.matches());
                return;
            }
            this.updateExcessAndMissingConstraintMatches(uncorruptedConstraintAnalysis.matches(), corruptedConstraintAnalysis.matches(), excessSet, missingSet);
        });
        StringBuilder analysis = new StringBuilder();
        analysis.append("Score corruption analysis:\n");
        String workingLabel = predicted ? "working" : "corrupted";
        this.appendAnalysis(analysis, workingLabel, "should not be there", excessSet);
        this.appendAnalysis(analysis, workingLabel, "are missing", missingSet);
        if (!missingSet.isEmpty() || !excessSet.isEmpty()) {
            analysis.append("  Maybe there is a bug in the score constraints of those ConstraintMatch(s).\n  Maybe a score constraint doesn't select all the entities it depends on,\n    but discovers some transitively through a reference from the selected entity.\n    This corrupts incremental score calculation,\n    because the constraint is not re-evaluated if the transitively discovered entity changes.\n".stripTrailing());
        } else if (predicted) {
            analysis.append("  If multi-threaded solving is active:\n    - the working scoreDirector is probably not the corrupted scoreDirector.\n    - maybe the rebase() method of the move is bugged.\n    - maybe a VariableListener affected the moveThread's workingSolution after doing and undoing a move,\n      but this didn't happen here on the solverThread, so we can't detect it.\n".stripTrailing());
        } else {
            analysis.append("  Impossible state. Maybe this is a bug in the scoreDirector (%s).".formatted(this.getClass()));
        }
        return analysis.toString();
    }

    private void appendAnalysis(StringBuilder analysis, String workingLabel, String suffix, Set<MatchAnalysis<Score_>> matches) {
        if (matches.isEmpty()) {
            analysis.append("  The %s scoreDirector has no ConstraintMatch(es) which %s.\n".formatted(workingLabel, suffix));
        } else {
            analysis.append("  The %s scoreDirector has %s ConstraintMatch(es) which %s:\n".formatted(workingLabel, matches.size(), suffix));
            matches.stream().sorted().limit(8L).forEach(match -> analysis.append("    %s/%s=%s\n".formatted(match.constraintRef().constraintId(), match.justification(), match.score())));
            if (matches.size() >= 8) {
                analysis.append("    ... %s more\n".formatted(matches.size() - 8));
            }
        }
    }

    private void updateExcessAndMissingConstraintMatches(List<MatchAnalysis<Score_>> uncorruptedList, List<MatchAnalysis<Score_>> corruptedList, Set<MatchAnalysis<Score_>> excessSet, Set<MatchAnalysis<Score_>> missingSet) {
        this.iterateAndAddIfFound(corruptedList, uncorruptedList, excessSet);
        this.iterateAndAddIfFound(uncorruptedList, corruptedList, missingSet);
    }

    private void iterateAndAddIfFound(List<MatchAnalysis<Score_>> referenceList, List<MatchAnalysis<Score_>> lookupList, Set<MatchAnalysis<Score_>> targetSet) {
        if (referenceList.isEmpty()) {
            return;
        }
        LinkedHashSet<MatchAnalysis<Score_>> lookupSet = new LinkedHashSet<MatchAnalysis<Score_>>(lookupList);
        for (MatchAnalysis<Score_> reference : referenceList) {
            if (lookupSet.contains(reference)) continue;
            targetSet.add(reference);
        }
    }

    protected boolean isConstraintConfiguration(Object problemFactOrEntity) {
        SolutionDescriptor solutionDescriptor = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
        ConstraintWeightSupplier constraintWeightSupplier = solutionDescriptor.getConstraintWeightSupplier();
        if (constraintWeightSupplier == null) {
            return false;
        }
        return constraintWeightSupplier.getProblemFactClass().isInstance(problemFactOrEntity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.calculationCount + ")";
    }
}

