/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.ConstraintAnalysis;
import ai.timefold.solver.core.api.score.analysis.MatchAnalysis;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.phase.scope.SolverLifecyclePoint;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;

public interface InnerScoreDirector<Solution_, Score_ extends Score<Score_>>
extends VariableDescriptorAwareScoreDirector<Solution_>,
AutoCloseable {
    public static <Score_ extends Score<Score_>> ConstraintAnalysis<Score_> getConstraintAnalysis(ConstraintMatchTotal<Score_> constraintMatchTotal, boolean analyzeConstraintMatches) {
        Object zero = constraintMatchTotal.getScore().zero();
        if (analyzeConstraintMatches) {
            Map<ConstraintJustification, List> deduplicatedConstraintMatchMap = CollectionUtils.newLinkedHashMap(constraintMatchTotal.getConstraintMatchCount());
            for (ConstraintMatch<Score_> constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                Object constraintJustification = constraintMatch.getJustification();
                List constraintMatchList = deduplicatedConstraintMatchMap.computeIfAbsent((ConstraintJustification)constraintJustification, k -> new ArrayList(1));
                constraintMatchList.add(constraintMatch);
            }
            List matchAnalyses = deduplicatedConstraintMatchMap.entrySet().stream().map(entry -> {
                Score score = ((List)entry.getValue()).stream().map(ConstraintMatch::getScore).reduce((Score)zero, Score::add);
                return new MatchAnalysis<Score>(constraintMatchTotal.getConstraintRef(), score, (ConstraintJustification)entry.getKey());
            }).toList();
            return new ConstraintAnalysis<Score_>(constraintMatchTotal.getConstraintRef(), constraintMatchTotal.getConstraintWeight(), constraintMatchTotal.getScore(), matchAnalyses);
        }
        return new ConstraintAnalysis<Score_>(constraintMatchTotal.getConstraintRef(), constraintMatchTotal.getConstraintWeight(), constraintMatchTotal.getScore(), null);
    }

    public void setWorkingSolution(Solution_ var1);

    public Score_ calculateScore();

    public boolean isConstraintMatchEnabled();

    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap();

    public Map<Object, Indictment<Score_>> getIndictmentMap();

    public long getWorkingEntityListRevision();

    public int getWorkingGenuineEntityCount();

    default public Score_ doAndProcessMove(Move<Solution_> move, boolean assertMoveScoreFromScratch) {
        return this.doAndProcessMove(move, assertMoveScoreFromScratch, null);
    }

    public Score_ doAndProcessMove(Move<Solution_> var1, boolean var2, Consumer<Score_> var3);

    public boolean isWorkingEntityListDirty(long var1);

    public boolean requiresFlushing();

    public boolean expectShadowVariablesInCorrectState();

    public InnerScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory();

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor();

    public ScoreDefinition<Score_> getScoreDefinition();

    default public Solution_ cloneWorkingSolution() {
        return this.cloneSolution(this.getWorkingSolution());
    }

    public Solution_ cloneSolution(Solution_ var1);

    public long getCalculationCount();

    public void resetCalculationCount();

    public void incrementCalculationCount();

    public SupplyManager getSupplyManager();

    public InnerScoreDirector<Solution_, Score_> createChildThreadScoreDirector(ChildThreadType var1);

    public void setAllChangesWillBeUndoneBeforeStepEnds(boolean var1);

    public void assertExpectedWorkingScore(Score_ var1, Object var2);

    public void assertShadowVariablesAreNotStale(Score_ var1, Object var2);

    public void assertWorkingScoreFromScratch(Score_ var1, Object var2);

    public void assertPredictedScoreFromScratch(Score_ var1, Object var2);

    public void assertExpectedUndoMoveScore(Move<Solution_> var1, Score_ var2, SolverLifecyclePoint var3);

    @Override
    public void close();

    public void forceTriggerVariableListeners();

    default public ScoreAnalysis<Score_> buildScoreAnalysis(boolean analyzeConstraintMatches) {
        return this.buildScoreAnalysis(analyzeConstraintMatches, ScoreAnalysisMode.DEFAULT);
    }

    default public ScoreAnalysis<Score_> buildScoreAnalysis(boolean analyzeConstraintMatches, ScoreAnalysisMode mode) {
        Score_ score = this.calculateScore();
        if (Objects.requireNonNull(mode) == ScoreAnalysisMode.RECOMMENDATION_API) {
            score = score.withInitScore(0);
        }
        TreeMap constraintAnalysisMap = new TreeMap();
        for (ConstraintMatchTotal<Score_> constraintMatchTotal : this.getConstraintMatchTotalMap().values()) {
            ConstraintAnalysis<Score_> constraintAnalysis = InnerScoreDirector.getConstraintAnalysis(constraintMatchTotal, analyzeConstraintMatches);
            constraintAnalysisMap.put(constraintMatchTotal.getConstraintRef(), constraintAnalysis);
        }
        return new ScoreAnalysis<Score_>(score, constraintAnalysisMap);
    }

    @Override
    default public void beforeEntityAdded(Object entity) {
        this.beforeEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> var1, Object var2);

    @Override
    default public void afterEntityAdded(Object entity) {
        this.afterEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void afterEntityAdded(EntityDescriptor<Solution_> var1, Object var2);

    @Override
    default public void beforeEntityRemoved(Object entity) {
        this.beforeEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> var1, Object var2);

    @Override
    default public void afterEntityRemoved(Object entity) {
        this.afterEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void afterEntityRemoved(EntityDescriptor<Solution_> var1, Object var2);

    @Override
    public void beforeProblemFactAdded(Object var1);

    @Override
    public void afterProblemFactAdded(Object var1);

    @Override
    public void beforeProblemPropertyChanged(Object var1);

    @Override
    public void afterProblemPropertyChanged(Object var1);

    @Override
    public void beforeProblemFactRemoved(Object var1);

    @Override
    public void afterProblemFactRemoved(Object var1);

    public static enum ScoreAnalysisMode {
        DEFAULT,
        SCORE_CORRUPTION,
        RECOMMENDATION_API;

    }
}

