/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director.easy;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.calculator.EasyScoreCalculator;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.easy.EasyScoreDirector;

public final class EasyScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirectorFactory<Solution_, Score_> {
    private final EasyScoreCalculator<Solution_, Score_> easyScoreCalculator;

    public static <Solution_, Score_ extends Score<Score_>> EasyScoreDirectorFactory<Solution_, Score_> buildScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, ScoreDirectorFactoryConfig config) {
        if (!EasyScoreCalculator.class.isAssignableFrom(config.getEasyScoreCalculatorClass())) {
            throw new IllegalArgumentException("The easyScoreCalculatorClass (%s) does not implement %s.".formatted(config.getEasyScoreCalculatorClass(), EasyScoreCalculator.class.getSimpleName()));
        }
        EasyScoreCalculator easyScoreCalculator = ConfigUtils.newInstance(config, "easyScoreCalculatorClass", config.getEasyScoreCalculatorClass());
        ConfigUtils.applyCustomProperties(easyScoreCalculator, "easyScoreCalculatorClass", config.getEasyScoreCalculatorCustomProperties(), "easyScoreCalculatorCustomProperties");
        return new EasyScoreDirectorFactory<Solution_, Score_>(solutionDescriptor, easyScoreCalculator);
    }

    public EasyScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, EasyScoreCalculator<Solution_, Score_> easyScoreCalculator) {
        super(solutionDescriptor);
        this.easyScoreCalculator = easyScoreCalculator;
    }

    @Override
    public EasyScoreDirector<Solution_, Score_> buildScoreDirector(boolean lookUpEnabled, boolean constraintMatchEnabledPreference, boolean expectShadowVariablesInCorrectState) {
        return new EasyScoreDirector<Solution_, Score_>(this, lookUpEnabled, constraintMatchEnabledPreference, expectShadowVariablesInCorrectState, this.easyScoreCalculator);
    }
}

