/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director.incremental;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.calculator.ConstraintMatchAwareIncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.calculator.IncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.score.constraint.DefaultIndictment;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.director.incremental.IncrementalScoreDirectorFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class IncrementalScoreDirector<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirector<Solution_, Score_, IncrementalScoreDirectorFactory<Solution_, Score_>> {
    private final IncrementalScoreCalculator<Solution_, Score_> incrementalScoreCalculator;

    public IncrementalScoreDirector(IncrementalScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference, boolean expectShadowVariablesInCorrectState, IncrementalScoreCalculator<Solution_, Score_> incrementalScoreCalculator) {
        super(scoreDirectorFactory, lookUpEnabled, constraintMatchEnabledPreference, expectShadowVariablesInCorrectState);
        this.incrementalScoreCalculator = incrementalScoreCalculator;
    }

    public IncrementalScoreCalculator<Solution_, Score_> getIncrementalScoreCalculator() {
        return this.incrementalScoreCalculator;
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        super.setWorkingSolution(workingSolution);
        if (this.incrementalScoreCalculator instanceof ConstraintMatchAwareIncrementalScoreCalculator) {
            ((ConstraintMatchAwareIncrementalScoreCalculator)this.incrementalScoreCalculator).resetWorkingSolution(workingSolution, this.constraintMatchEnabledPreference);
        } else {
            this.incrementalScoreCalculator.resetWorkingSolution(workingSolution);
        }
    }

    @Override
    public Score_ calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        Score_ score = this.incrementalScoreCalculator.calculateScore();
        if (score == null) {
            throw new IllegalStateException("The incrementalScoreCalculator (" + this.incrementalScoreCalculator.getClass() + ") must return a non-null score (" + score + ") in the method calculateScore().");
        }
        if (!score.isSolutionInitialized()) {
            throw new IllegalStateException("The score (" + this + ")'s initScore (" + score.initScore() + ") should be 0.\nMaybe the score calculator (" + this.incrementalScoreCalculator.getClass() + ") is calculating the initScore too, although it's the score director's responsibility.");
        }
        int workingInitScore = this.getWorkingInitScore();
        if (workingInitScore != 0) {
            score = score.withInitScore(workingInitScore);
        }
        this.setCalculatedScore(score);
        return score;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabledPreference && this.incrementalScoreCalculator instanceof ConstraintMatchAwareIncrementalScoreCalculator;
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled in the constructor, this method should not be called.");
        }
        return ((ConstraintMatchAwareIncrementalScoreCalculator)this.incrementalScoreCalculator).getConstraintMatchTotals().stream().collect(Collectors.toMap(c -> c.getConstraintRef().constraintId(), Function.identity()));
    }

    @Override
    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled in the constructor, this method should not be called.");
        }
        Map incrementalIndictmentMap = ((ConstraintMatchAwareIncrementalScoreCalculator)this.incrementalScoreCalculator).getIndictmentMap();
        if (incrementalIndictmentMap != null) {
            return incrementalIndictmentMap;
        }
        LinkedHashMap indictmentMap = new LinkedHashMap();
        Object zeroScore = this.getScoreDefinition().getZeroScore();
        Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap = this.getConstraintMatchTotalMap();
        for (ConstraintMatchTotal<Score_> constraintMatchTotal : constraintMatchTotalMap.values()) {
            for (ConstraintMatch constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                constraintMatch.getIndictedObjectList().stream().filter(Objects::nonNull).distinct().forEach(fact -> {
                    DefaultIndictment indictment = (DefaultIndictment)indictmentMap.computeIfAbsent(fact, k -> new DefaultIndictment<Score>(fact, (Score)zeroScore));
                    indictment.addConstraintMatch(constraintMatch);
                });
            }
        }
        return indictmentMap;
    }

    @Override
    public boolean requiresFlushing() {
        return true;
    }

    @Override
    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeEntityAdded(entity);
        super.beforeEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterEntityAdded(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeVariableChanged(entity, variableDescriptor.getVariableName());
        super.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterVariableChanged(entity, variableDescriptor.getVariableName());
        super.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void beforeListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.incrementalScoreCalculator.beforeListVariableElementAssigned(variableDescriptor.getVariableName(), element);
        super.beforeListVariableElementAssigned(variableDescriptor, element);
    }

    @Override
    public void afterListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.incrementalScoreCalculator.afterListVariableElementAssigned(variableDescriptor.getVariableName(), element);
        super.afterListVariableElementAssigned(variableDescriptor, element);
    }

    @Override
    public void beforeListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.incrementalScoreCalculator.beforeListVariableElementUnassigned(variableDescriptor.getVariableName(), element);
        super.beforeListVariableElementUnassigned(variableDescriptor, element);
    }

    @Override
    public void afterListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.incrementalScoreCalculator.afterListVariableElementUnassigned(variableDescriptor.getVariableName(), element);
        super.afterListVariableElementUnassigned(variableDescriptor, element);
    }

    @Override
    public void beforeListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        this.incrementalScoreCalculator.beforeListVariableChanged(entity, variableDescriptor.getVariableName(), fromIndex, toIndex);
        super.beforeListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        this.incrementalScoreCalculator.afterListVariableChanged(entity, variableDescriptor.getVariableName(), fromIndex, toIndex);
        super.afterListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeEntityRemoved(entity);
        super.beforeEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterEntityRemoved(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
        super.beforeProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void beforeProblemPropertyChanged(Object problemFactOrEntity) {
        super.beforeProblemPropertyChanged(problemFactOrEntity);
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemPropertyChanged(problemFactOrEntity);
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
        super.beforeProblemFactRemoved(problemFact);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemFactRemoved(problemFact);
    }
}

