/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet;

import ai.timefold.solver.core.api.score.stream.Joiners;
import ai.timefold.solver.core.api.score.stream.uni.UniConstraintStream;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraint;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetAbstractUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetForEachUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.common.InnerConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class BavetConstraintFactory<Solution_>
extends InnerConstraintFactory<Solution_, BavetConstraint<Solution_>> {
    private static final String DEFAULT_CONSTRAINT_PACKAGE = "unnamed.package";
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final EnvironmentMode environmentMode;
    private final String defaultConstraintPackage;
    private final Map<BavetAbstractConstraintStream<Solution_>, BavetAbstractConstraintStream<Solution_>> sharingStreamMap = new HashMap<BavetAbstractConstraintStream<Solution_>, BavetAbstractConstraintStream<Solution_>>(256);

    public BavetConstraintFactory(SolutionDescriptor<Solution_> solutionDescriptor, EnvironmentMode environmentMode) {
        this.solutionDescriptor = solutionDescriptor;
        this.environmentMode = Objects.requireNonNull(environmentMode);
        ConstraintWeightSupplier weightSupplier = solutionDescriptor.getConstraintWeightSupplier();
        this.defaultConstraintPackage = weightSupplier == null ? BavetConstraintFactory.determineDefaultConstraintPackage(solutionDescriptor.getSolutionClass().getPackage()) : BavetConstraintFactory.determineDefaultConstraintPackage(weightSupplier.getDefaultConstraintPackage());
    }

    private static String determineDefaultConstraintPackage(Package pkg) {
        String asString = pkg == null ? "" : pkg.getName();
        return BavetConstraintFactory.determineDefaultConstraintPackage(asString);
    }

    private static String determineDefaultConstraintPackage(String constraintPackage) {
        return constraintPackage == null || constraintPackage.isEmpty() ? DEFAULT_CONSTRAINT_PACKAGE : constraintPackage;
    }

    public <Stream_ extends BavetAbstractConstraintStream<Solution_>> Stream_ share(Stream_ stream) {
        return (Stream_)this.share(stream, t -> {});
    }

    public <Stream_ extends BavetAbstractConstraintStream<Solution_>> Stream_ share(Stream_ stream, Consumer<Stream_> consumer) {
        return (Stream_)this.sharingStreamMap.computeIfAbsent(stream, k -> {
            consumer.accept(stream);
            return stream;
        });
    }

    @Override
    public <A> UniConstraintStream<A> forEach(Class<A> sourceClass) {
        this.assertValidFromType(sourceClass);
        EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptor(sourceClass);
        if (entityDescriptor == null) {
            return this.share(new BavetForEachUniConstraintStream(this, sourceClass, null, RetrievalSemantics.STANDARD));
        }
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
        if (listVariableDescriptor == null || !listVariableDescriptor.acceptsValueType(sourceClass)) {
            return this.share(new BavetForEachUniConstraintStream(this, sourceClass, entityDescriptor.getHasNoNullVariablesPredicateBasicVar(), RetrievalSemantics.STANDARD));
        }
        Class<?> entityClass = listVariableDescriptor.getEntityDescriptor().getEntityClass();
        if (entityClass == sourceClass) {
            throw new IllegalStateException("Impossible state: entityClass (%s) and sourceClass (%s) are the same.".formatted(entityClass.getCanonicalName(), sourceClass.getCanonicalName()));
        }
        InverseRelationShadowVariableDescriptor<Solution_> shadowDescriptor = listVariableDescriptor.getInverseRelationShadowVariableDescriptor();
        if (shadowDescriptor == null) {
            return this.forEachIncludingUnassigned(sourceClass).ifExists(entityClass, Joiners.filtering(listVariableDescriptor.getInListPredicate()));
        }
        return this.share(new BavetForEachUniConstraintStream(this, sourceClass, entityDescriptor.getHasNoNullVariablesPredicateListVar(), RetrievalSemantics.STANDARD));
    }

    @Override
    public <A> UniConstraintStream<A> forEachIncludingUnassigned(Class<A> sourceClass) {
        this.assertValidFromType(sourceClass);
        return this.share(new BavetForEachUniConstraintStream(this, sourceClass, null, RetrievalSemantics.STANDARD));
    }

    @Override
    public <A> UniConstraintStream<A> from(Class<A> fromClass) {
        this.assertValidFromType(fromClass);
        EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptor(fromClass);
        if (entityDescriptor != null && entityDescriptor.hasAnyGenuineVariables()) {
            Predicate<Object> predicate = entityDescriptor.getIsInitializedPredicate();
            return this.share(new BavetForEachUniConstraintStream(this, fromClass, predicate, RetrievalSemantics.LEGACY));
        }
        return this.share(new BavetForEachUniConstraintStream(this, fromClass, null, RetrievalSemantics.LEGACY));
    }

    public <A> BavetAbstractUniConstraintStream<Solution_, A> fromUnfiltered(Class<A> fromClass) {
        this.assertValidFromType(fromClass);
        return this.share(new BavetForEachUniConstraintStream(this, fromClass, null, RetrievalSemantics.LEGACY));
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    @Override
    public String getDefaultConstraintPackage() {
        return this.defaultConstraintPackage;
    }
}

