/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.impl.score.stream.bavet.NodeNetwork;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.AbstractForEachUniNode;
import ai.timefold.solver.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import java.util.IdentityHashMap;
import java.util.Map;

public final class BavetConstraintSession<Score_ extends Score<Score_>> {
    private final AbstractScoreInliner<Score_> scoreInliner;
    private final NodeNetwork nodeNetwork;
    private final Map<Class<?>, AbstractForEachUniNode<Object>[]> effectiveClassToNodeArrayMap;

    BavetConstraintSession(AbstractScoreInliner<Score_> scoreInliner) {
        this(scoreInliner, NodeNetwork.EMPTY);
    }

    BavetConstraintSession(AbstractScoreInliner<Score_> scoreInliner, NodeNetwork nodeNetwork) {
        this.scoreInliner = scoreInliner;
        this.nodeNetwork = nodeNetwork;
        this.effectiveClassToNodeArrayMap = new IdentityHashMap(nodeNetwork.forEachNodeCount());
    }

    public void insert(Object fact) {
        Class<?> factClass = fact.getClass();
        for (AbstractForEachUniNode<Object> node : this.findNodes(factClass)) {
            node.insert(fact);
        }
    }

    private AbstractForEachUniNode<Object>[] findNodes(Class<?> factClass) {
        AbstractForEachUniNode<Object>[] nodeArray = this.effectiveClassToNodeArrayMap.get(factClass);
        if (nodeArray == null) {
            nodeArray = this.nodeNetwork.getApplicableForEachNodes(factClass);
            this.effectiveClassToNodeArrayMap.put(factClass, nodeArray);
        }
        return nodeArray;
    }

    public void update(Object fact) {
        Class<?> factClass = fact.getClass();
        for (AbstractForEachUniNode<Object> node : this.findNodes(factClass)) {
            node.update(fact);
        }
    }

    public void retract(Object fact) {
        Class<?> factClass = fact.getClass();
        for (AbstractForEachUniNode<Object> node : this.findNodes(factClass)) {
            node.retract(fact);
        }
    }

    public Score_ calculateScore(int initScore) {
        this.nodeNetwork.propagate();
        return this.scoreInliner.extractScore(initScore);
    }

    public AbstractScoreInliner<Score_> getScoreInliner() {
        return this.scoreInliner;
    }

    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        return this.scoreInliner.getConstraintIdToConstraintMatchTotalMap();
    }

    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        return this.scoreInliner.getIndictmentMap();
    }
}

