/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.bi;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraint;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.bi.BavetAbstractBiConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.bi.BiScorer;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetScoringConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ConstraintMatchSupplier;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ScoreContext;
import ai.timefold.solver.core.impl.score.stream.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.impl.score.stream.common.inliner.WeightedScoreImpacter;
import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;

final class BavetScoringBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B>
implements BavetScoringConstraintStream<Solution_> {
    private final ToIntBiFunction<A, B> intMatchWeigher;
    private final ToLongBiFunction<A, B> longMatchWeigher;
    private final BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher;
    private BavetConstraint<Solution_> constraint;

    public BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, ToIntBiFunction<A, B> intMatchWeigher) {
        this(constraintFactory, parent, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, ToLongBiFunction<A, B> longMatchWeigher) {
        this(constraintFactory, parent, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, ToIntBiFunction<A, B> intMatchWeigher, ToLongBiFunction<A, B> longMatchWeigher, BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent);
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public void setConstraint(BavetConstraint<Solution_> constraint) {
        this.constraint = constraint;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        this.assertEmptyChildStreamList();
        boolean constraintMatchEnabled = buildHelper.getScoreInliner().isConstraintMatchEnabled();
        TriFunction<WeightedScoreImpacter<?, ?>, A, B, UndoScoreImpacter> scoreImpacter = constraintMatchEnabled ? this.buildScoreImpacterWithConstraintMatch() : this.buildScoreImpacter();
        WeightedScoreImpacter<Score_, ?> weightedScoreImpacter = buildHelper.getScoreInliner().buildWeightedScoreImpacter(this.constraint);
        BiScorer<A, B> scorer = new BiScorer<A, B>(weightedScoreImpacter, scoreImpacter, buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource()));
        buildHelper.putInsertUpdateRetract(this, scorer);
    }

    private TriFunction<WeightedScoreImpacter<?, ?>, A, B, UndoScoreImpacter> buildScoreImpacter() {
        if (this.intMatchWeigher != null) {
            return (impacter, a, b) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b);
                return impacter.impactScore(matchWeight, null);
            };
        }
        if (this.longMatchWeigher != null) {
            return (impacter, a, b) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b);
                return impacter.impactScore(matchWeight, null);
            };
        }
        if (this.bigDecimalMatchWeigher != null) {
            return (impacter, a, b) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b);
                return impacter.impactScore(matchWeight, null);
            };
        }
        throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
    }

    private TriFunction<WeightedScoreImpacter<?, ?>, A, B, UndoScoreImpacter> buildScoreImpacterWithConstraintMatch() {
        if (this.intMatchWeigher != null) {
            return (impacter, a, b) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b);
                return BavetScoringBiConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a, b);
            };
        }
        if (this.longMatchWeigher != null) {
            return (impacter, a, b) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b);
                return BavetScoringBiConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a, b);
            };
        }
        if (this.bigDecimalMatchWeigher != null) {
            return (impacter, a, b) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b);
                return BavetScoringBiConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a, b);
            };
        }
        throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
    }

    private static <A, B, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, int matchWeight, A a, B b) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((TriFunction)constraint.getJustificationMapping(), (BiFunction)constraint.getIndictedObjectsMapping(), a, b);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    private static <A, B, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, long matchWeight, A a, B b) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((TriFunction)constraint.getJustificationMapping(), (BiFunction)constraint.getIndictedObjectsMapping(), a, b);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    private static <A, B, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, BigDecimal matchWeight, A a, B b) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((TriFunction)constraint.getJustificationMapping(), (BiFunction)constraint.getIndictedObjectsMapping(), a, b);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    public String toString() {
        return "Scoring(" + this.constraint.getConstraintRef() + ")";
    }
}

