/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.common;

import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.Propagator;
import ai.timefold.solver.core.impl.score.stream.bavet.common.StaticPropagationQueue;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractFlattenLastNode<InTuple_ extends AbstractTuple, OutTuple_ extends AbstractTuple, EffectiveItem_, FlattenedItem_>
extends AbstractNode
implements TupleLifecycle<InTuple_> {
    private final int flattenLastStoreIndex;
    private final Function<EffectiveItem_, Iterable<FlattenedItem_>> mappingFunction;
    private final StaticPropagationQueue<OutTuple_> propagationQueue;

    protected AbstractFlattenLastNode(int flattenLastStoreIndex, Function<EffectiveItem_, Iterable<FlattenedItem_>> mappingFunction, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle) {
        this.flattenLastStoreIndex = flattenLastStoreIndex;
        this.mappingFunction = Objects.requireNonNull(mappingFunction);
        this.propagationQueue = new StaticPropagationQueue<OutTuple_>(nextNodesTupleLifecycle);
    }

    @Override
    public final void insert(InTuple_ tuple) {
        if (((AbstractTuple)tuple).getStore(this.flattenLastStoreIndex) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tuple + ") was already added in the tupleStore.");
        }
        Iterable<FlattenedItem_> iterable = this.mappingFunction.apply(this.getEffectiveFactIn(tuple));
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            int size = collection.size();
            if (size == 0) {
                return;
            }
            ArrayList outTupleList = new ArrayList(size);
            for (Object item : collection) {
                this.addTuple(tuple, item, outTupleList);
            }
            ((AbstractTuple)tuple).setStore(this.flattenLastStoreIndex, outTupleList);
        } else {
            Iterator<FlattenedItem_> iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                return;
            }
            ArrayList outTupleList = new ArrayList();
            while (iterator.hasNext()) {
                this.addTuple(tuple, iterator.next(), outTupleList);
            }
            ((AbstractTuple)tuple).setStore(this.flattenLastStoreIndex, outTupleList);
        }
    }

    private void addTuple(InTuple_ originalTuple, FlattenedItem_ item, List<OutTuple_> outTupleList) {
        OutTuple_ tuple = this.createTuple(originalTuple, item);
        outTupleList.add(tuple);
        this.propagationQueue.insert(tuple);
    }

    protected abstract OutTuple_ createTuple(InTuple_ var1, FlattenedItem_ var2);

    @Override
    public final void update(InTuple_ tuple) {
        List outTupleList = (List)((AbstractTuple)tuple).getStore(this.flattenLastStoreIndex);
        if (outTupleList == null) {
            this.insert(tuple);
            return;
        }
        Iterable<FlattenedItem_> iterable = this.mappingFunction.apply(this.getEffectiveFactIn(tuple));
        List<FlattenedItem_> newFlattenedItemList = this.iterableToList(iterable);
        if (newFlattenedItemList.isEmpty()) {
            this.retract(tuple);
            return;
        }
        if (!outTupleList.isEmpty()) {
            Iterator outTupleIterator = outTupleList.iterator();
            while (outTupleIterator.hasNext()) {
                AbstractTuple outTuple = (AbstractTuple)outTupleIterator.next();
                FlattenedItem_ existingFlattenedItem = this.getEffectiveFactOut(outTuple);
                boolean existsAlsoInNew = false;
                if (!newFlattenedItemList.isEmpty()) {
                    Iterator<FlattenedItem_> newFlattenedItemIterator = newFlattenedItemList.iterator();
                    while (newFlattenedItemIterator.hasNext()) {
                        FlattenedItem_ newFlattenedItem = newFlattenedItemIterator.next();
                        if (newFlattenedItem != existingFlattenedItem) continue;
                        newFlattenedItemIterator.remove();
                        existsAlsoInNew = true;
                        break;
                    }
                }
                if (!existsAlsoInNew) {
                    outTupleIterator.remove();
                    this.removeTuple(outTuple);
                    continue;
                }
                this.propagationQueue.update((OutTuple_)outTuple);
            }
        }
        for (FlattenedItem_ newFlattenedItem : newFlattenedItemList) {
            this.addTuple(tuple, newFlattenedItem, outTupleList);
        }
    }

    private List<FlattenedItem_> iterableToList(Iterable<FlattenedItem_> iterable) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            int size = collection.size();
            if (size == 0) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList(size);
            iterable.forEach(result::add);
            return result;
        }
        Iterator<FlattenedItem_> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<FlattenedItem_> result = new ArrayList<FlattenedItem_>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    protected abstract EffectiveItem_ getEffectiveFactIn(InTuple_ var1);

    protected abstract FlattenedItem_ getEffectiveFactOut(OutTuple_ var1);

    @Override
    public final void retract(InTuple_ tuple) {
        List outTupleList = (List)((AbstractTuple)tuple).removeStore(this.flattenLastStoreIndex);
        if (outTupleList == null) {
            return;
        }
        for (AbstractTuple item : outTupleList) {
            this.removeTuple(item);
        }
    }

    private void removeTuple(OutTuple_ outTuple) {
        TupleState state = ((AbstractTuple)outTuple).state;
        if (!state.isActive()) {
            throw new IllegalStateException("Impossible state: The tuple (" + outTuple + ") is in an unexpected state (" + ((AbstractTuple)outTuple).state + ").");
        }
        this.propagationQueue.retract(outTuple, state == TupleState.CREATING ? TupleState.ABORTING : TupleState.DYING);
    }

    @Override
    public Propagator getPropagator() {
        return this.propagationQueue;
    }
}

