/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.common;

import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.DynamicPropagationQueue;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ExistsCounter;
import ai.timefold.solver.core.impl.score.stream.bavet.common.Propagator;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleState;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;

public abstract class AbstractIfExistsNode<LeftTuple_ extends AbstractTuple, Right_>
extends AbstractNode
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    protected final boolean shouldExist;
    protected final int inputStoreIndexLeftTrackerList;
    protected final int inputStoreIndexRightTrackerList;
    protected final boolean isFiltering;
    private final DynamicPropagationQueue<LeftTuple_, ExistsCounter<LeftTuple_>> propagationQueue;

    protected AbstractIfExistsNode(boolean shouldExist, int inputStoreIndexLeftTrackerList, int inputStoreIndexRightTrackerList, TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle, boolean isFiltering) {
        this.shouldExist = shouldExist;
        this.inputStoreIndexLeftTrackerList = inputStoreIndexLeftTrackerList;
        this.inputStoreIndexRightTrackerList = inputStoreIndexRightTrackerList;
        this.isFiltering = isFiltering;
        this.propagationQueue = new DynamicPropagationQueue(nextNodesTupleLifecycle);
    }

    protected abstract boolean testFiltering(LeftTuple_ var1, UniTuple<Right_> var2);

    protected void initCounterLeft(ExistsCounter<LeftTuple_> counter) {
        if (this.shouldExist ? counter.countRight > 0 : counter.countRight == 0) {
            this.propagationQueue.insert(counter);
        }
    }

    protected final void updateUnchangedCounterLeft(ExistsCounter<LeftTuple_> counter) {
        if (counter.state != TupleState.OK) {
            return;
        }
        this.propagationQueue.update(counter);
    }

    protected void updateCounterLeft(ExistsCounter<LeftTuple_> counter) {
        block11: {
            TupleState state;
            block10: {
                state = counter.state;
                if (!(this.shouldExist ? counter.countRight > 0 : counter.countRight == 0)) break block10;
                switch (state) {
                    case CREATING: 
                    case UPDATING: {
                        break block11;
                    }
                    case OK: 
                    case DYING: {
                        this.propagationQueue.update(counter);
                        break block11;
                    }
                    case DEAD: 
                    case ABORTING: {
                        this.propagationQueue.insert(counter);
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException("Impossible state: the counter (" + counter + ") has an impossible insert state (" + state + ").");
                    }
                }
            }
            if (!state.isActive()) {
                return;
            }
            switch (state) {
                case CREATING: {
                    this.propagationQueue.retract(counter, TupleState.ABORTING);
                    break;
                }
                case UPDATING: 
                case OK: {
                    this.propagationQueue.retract(counter, TupleState.DYING);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: The counter (" + counter + ") has an impossible retract state (" + state + ").");
                }
            }
        }
    }

    protected void killCounterLeft(ExistsCounter<LeftTuple_> counter) {
        if (this.shouldExist ? counter.countRight > 0 : counter.countRight == 0) {
            this.doRetractCounter(counter);
        }
    }

    protected void incrementCounterRight(ExistsCounter<LeftTuple_> counter) {
        if (counter.countRight == 0) {
            if (this.shouldExist) {
                this.doInsertCounter(counter);
            } else {
                this.doRetractCounter(counter);
            }
        }
        ++counter.countRight;
    }

    protected void decrementCounterRight(ExistsCounter<LeftTuple_> counter) {
        --counter.countRight;
        if (counter.countRight == 0) {
            if (this.shouldExist) {
                this.doRetractCounter(counter);
            } else {
                this.doInsertCounter(counter);
            }
        }
    }

    protected ElementAwareList<FilteringTracker<LeftTuple_>> updateRightTrackerList(UniTuple<Right_> rightTuple) {
        ElementAwareList rightTrackerList = (ElementAwareList)rightTuple.getStore(this.inputStoreIndexRightTrackerList);
        for (FilteringTracker tuple : rightTrackerList) {
            this.decrementCounterRight(tuple.counter);
            tuple.remove();
        }
        return rightTrackerList;
    }

    protected void updateCounterFromLeft(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple, ExistsCounter<LeftTuple_> counter, ElementAwareList<FilteringTracker<LeftTuple_>> leftTrackerList) {
        if (this.testFiltering(leftTuple, rightTuple)) {
            ++counter.countRight;
            ElementAwareList rightTrackerList = (ElementAwareList)rightTuple.getStore(this.inputStoreIndexRightTrackerList);
            new FilteringTracker<LeftTuple_>(counter, leftTrackerList, rightTrackerList);
        }
    }

    protected void updateCounterFromRight(UniTuple<Right_> rightTuple, ExistsCounter<LeftTuple_> counter, ElementAwareList<FilteringTracker<LeftTuple_>> rightTrackerList) {
        if (this.testFiltering(counter.leftTuple, rightTuple)) {
            this.incrementCounterRight(counter);
            ElementAwareList leftTrackerList = (ElementAwareList)((AbstractTuple)counter.leftTuple).getStore(this.inputStoreIndexLeftTrackerList);
            new FilteringTracker<LeftTuple_>(counter, leftTrackerList, rightTrackerList);
        }
    }

    private void doInsertCounter(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case DYING: {
                this.propagationQueue.update(counter);
                break;
            }
            case DEAD: 
            case ABORTING: {
                this.propagationQueue.insert(counter);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: the counter (" + counter + ") has an impossible insert state (" + counter.state + ").");
            }
        }
    }

    private void doRetractCounter(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case CREATING: {
                this.propagationQueue.retract(counter, TupleState.ABORTING);
                break;
            }
            case UPDATING: 
            case OK: {
                this.propagationQueue.retract(counter, TupleState.DYING);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The counter (" + counter + ") has an impossible retract state (" + counter.state + ").");
            }
        }
    }

    @Override
    public Propagator getPropagator() {
        return this.propagationQueue;
    }

    protected static final class FilteringTracker<LeftTuple_ extends AbstractTuple> {
        final ExistsCounter<LeftTuple_> counter;
        private final ElementAwareListEntry<FilteringTracker<LeftTuple_>> leftTrackerEntry;
        private final ElementAwareListEntry<FilteringTracker<LeftTuple_>> rightTrackerEntry;

        FilteringTracker(ExistsCounter<LeftTuple_> counter, ElementAwareList<FilteringTracker<LeftTuple_>> leftTrackerList, ElementAwareList<FilteringTracker<LeftTuple_>> rightTrackerList) {
            this.counter = counter;
            this.leftTrackerEntry = leftTrackerList.add(this);
            this.rightTrackerEntry = rightTrackerList.add(this);
        }

        public void remove() {
            this.leftTrackerEntry.remove();
            this.rightTrackerEntry.remove();
        }
    }
}

