/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.quad;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetAftBridgeBiConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.BavetAbstractQuadConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.MapQuadToBiNode;
import java.util.Objects;

final class BavetBiMapQuadConstraintStream<Solution_, A, B, C, D, NewA, NewB>
extends BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> {
    private final QuadFunction<A, B, C, D, NewA> mappingFunctionA;
    private final QuadFunction<A, B, C, D, NewB> mappingFunctionB;
    private BavetAftBridgeBiConstraintStream<Solution_, NewA, NewB> aftStream;

    public BavetBiMapQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, QuadFunction<A, B, C, D, NewA> mappingFunctionA, QuadFunction<A, B, C, D, NewB> mappingFunctionB) {
        super(constraintFactory, parent);
        this.mappingFunctionA = mappingFunctionA;
        this.mappingFunctionB = mappingFunctionB;
    }

    public void setAftBridge(BavetAftBridgeBiConstraintStream<Solution_, NewA, NewB> aftStream) {
        this.aftStream = aftStream;
    }

    @Override
    public boolean guaranteesDistinct() {
        return false;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        this.assertEmptyChildStreamList();
        int inputStoreIndex = buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this.aftStream);
        MapQuadToBiNode<A, B, C, D, NewA, NewB> node = new MapQuadToBiNode<A, B, C, D, NewA, NewB>(inputStoreIndex, this.mappingFunctionA, this.mappingFunctionB, buildHelper.getAggregatedTupleLifecycle(this.aftStream.getChildStreamList()), outputStoreSize);
        buildHelper.addNode(node, this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BavetBiMapQuadConstraintStream that = (BavetBiMapQuadConstraintStream)object;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.mappingFunctionA, that.mappingFunctionA) && Objects.equals(this.mappingFunctionB, that.mappingFunctionB);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.mappingFunctionA, this.mappingFunctionB);
    }

    public String toString() {
        return "BiMap()";
    }
}

