/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.quad;

import ai.timefold.solver.core.api.function.PentaFunction;
import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.ToIntQuadFunction;
import ai.timefold.solver.core.api.function.ToLongQuadFunction;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraint;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetScoringConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.BavetAbstractQuadConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.QuadScorer;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ConstraintMatchSupplier;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ScoreContext;
import ai.timefold.solver.core.impl.score.stream.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.impl.score.stream.common.inliner.WeightedScoreImpacter;
import java.math.BigDecimal;

final class BavetScoringQuadConstraintStream<Solution_, A, B, C, D>
extends BavetAbstractQuadConstraintStream<Solution_, A, B, C, D>
implements BavetScoringConstraintStream<Solution_> {
    private final ToIntQuadFunction<A, B, C, D> intMatchWeigher;
    private final ToLongQuadFunction<A, B, C, D> longMatchWeigher;
    private final QuadFunction<A, B, C, D, BigDecimal> bigDecimalMatchWeigher;
    private BavetConstraint<Solution_> constraint;

    public BavetScoringQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, ToIntQuadFunction<A, B, C, D> intMatchWeigher) {
        this(constraintFactory, parent, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, ToLongQuadFunction<A, B, C, D> longMatchWeigher) {
        this(constraintFactory, parent, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, QuadFunction<A, B, C, D, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, ToIntQuadFunction<A, B, C, D> intMatchWeigher, ToLongQuadFunction<A, B, C, D> longMatchWeigher, QuadFunction<A, B, C, D, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent);
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public void setConstraint(BavetConstraint<Solution_> constraint) {
        this.constraint = constraint;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        this.assertEmptyChildStreamList();
        boolean constraintMatchEnabled = buildHelper.getScoreInliner().isConstraintMatchEnabled();
        PentaFunction<WeightedScoreImpacter<?, ?>, A, B, C, D, UndoScoreImpacter> scoreImpacter = constraintMatchEnabled ? this.buildScoreImpacterWithConstraintMatch() : this.buildScoreImpacter();
        WeightedScoreImpacter<Score_, ?> weightedScoreImpacter = buildHelper.getScoreInliner().buildWeightedScoreImpacter(this.constraint);
        QuadScorer<A, B, C, D> scorer = new QuadScorer<A, B, C, D>(weightedScoreImpacter, scoreImpacter, buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource()));
        buildHelper.putInsertUpdateRetract(this, scorer);
    }

    private PentaFunction<WeightedScoreImpacter<?, ?>, A, B, C, D, UndoScoreImpacter> buildScoreImpacter() {
        if (this.intMatchWeigher != null) {
            return (impacter, a, b, c, d) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b, c, d);
                return impacter.impactScore(matchWeight, null);
            };
        }
        if (this.longMatchWeigher != null) {
            return (impacter, a, b, c, d) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b, c, d);
                return impacter.impactScore(matchWeight, null);
            };
        }
        if (this.bigDecimalMatchWeigher != null) {
            return (impacter, a, b, c, d) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b, c, d);
                return impacter.impactScore(matchWeight, null);
            };
        }
        throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
    }

    private PentaFunction<WeightedScoreImpacter<?, ?>, A, B, C, D, UndoScoreImpacter> buildScoreImpacterWithConstraintMatch() {
        if (this.intMatchWeigher != null) {
            return (impacter, a, b, c, d) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b, c, d);
                return BavetScoringQuadConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a, b, c, d);
            };
        }
        if (this.longMatchWeigher != null) {
            return (impacter, a, b, c, d) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b, c, d);
                return BavetScoringQuadConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a, b, c, d);
            };
        }
        if (this.bigDecimalMatchWeigher != null) {
            return (impacter, a, b, c, d) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b, c, d);
                return BavetScoringQuadConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a, b, c, d);
            };
        }
        throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
    }

    private static <A, B, C, D, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, int matchWeight, A a, B b, C c, D d) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((PentaFunction)constraint.getJustificationMapping(), (QuadFunction)constraint.getIndictedObjectsMapping(), a, b, c, d);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    private static <A, B, C, D, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, long matchWeight, A a, B b, C c, D d) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((PentaFunction)constraint.getJustificationMapping(), (QuadFunction)constraint.getIndictedObjectsMapping(), a, b, c, d);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    private static <A, B, C, D, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, BigDecimal matchWeight, A a, B b, C c, D d) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((PentaFunction)constraint.getJustificationMapping(), (QuadFunction)constraint.getIndictedObjectsMapping(), a, b, c, d);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    public String toString() {
        return "Scoring(" + this.constraint.getConstraintRef() + ")";
    }
}

