/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.quad;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractConcatNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetConcatConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetForeBridgeQuadConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetForeBridgeUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.BavetAbstractQuadConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.ConcatQuadUniNode;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.ConcatUniQuadNode;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public final class BavetUniConcatQuadConstraintStream<Solution_, A, B, C, D>
extends BavetAbstractQuadConstraintStream<Solution_, A, B, C, D>
implements BavetConcatConstraintStream<Solution_> {
    private final BavetAbstractConstraintStream<Solution_> leftParent;
    private final BavetAbstractConstraintStream<Solution_> rightParent;
    private final Function<A, B> paddingFunctionB;
    private final Function<A, C> paddingFunctionC;
    private final Function<A, D> paddingFunctionD;
    private final ConcatNodeConstructor<A, B, C, D> nodeConstructor;

    public BavetUniConcatQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeUniConstraintStream<Solution_, A> leftParent, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> rightParent, Function<A, B> paddingFunctionB, Function<A, C> paddingFunctionC, Function<A, D> paddingFunctionD) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.paddingFunctionB = paddingFunctionB;
        this.paddingFunctionC = paddingFunctionC;
        this.paddingFunctionD = paddingFunctionD;
        this.nodeConstructor = ConcatUniQuadNode::new;
    }

    public BavetUniConcatQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> leftParent, BavetForeBridgeUniConstraintStream<Solution_, A> rightParent, Function<A, B> paddingFunctionB, Function<A, C> paddingFunctionC, Function<A, D> paddingFunctionD) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.paddingFunctionB = paddingFunctionB;
        this.paddingFunctionC = paddingFunctionC;
        this.paddingFunctionD = paddingFunctionD;
        this.nodeConstructor = ConcatQuadUniNode::new;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        int leftCloneStoreIndex = buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource());
        int rightCloneStoreIndex = buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        AbstractConcatNode<?, ?, ?> node = this.nodeConstructor.apply(this.paddingFunctionB, this.paddingFunctionC, this.paddingFunctionD, downstream, leftCloneStoreIndex, rightCloneStoreIndex, outputStoreSize);
        buildHelper.addNode(node, this, this.leftParent, this.rightParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetUniConcatQuadConstraintStream other = (BavetUniConcatQuadConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), other.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), other.rightParent.getParent());
    }

    public int hashCode() {
        return Objects.hash(this.leftParent.getParent(), this.rightParent.getParent());
    }

    public String toString() {
        return "UniConcat() with " + this.childStreamList.size() + " children";
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getLeftParent() {
        return this.leftParent;
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getRightParent() {
        return this.rightParent;
    }

    private static interface ConcatNodeConstructor<A, B, C, D> {
        public AbstractConcatNode<?, ?, ?> apply(Function<A, B> var1, Function<A, C> var2, Function<A, D> var3, TupleLifecycle<QuadTuple<A, B, C, D>> var4, int var5, int var6, int var7);
    }
}

