/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.tri;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetAftBridgeBiConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.tri.BavetAbstractTriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.tri.MapTriToBiNode;
import java.util.Objects;

final class BavetBiMapTriConstraintStream<Solution_, A, B, C, NewA, NewB>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C> {
    private final TriFunction<A, B, C, NewA> mappingFunctionA;
    private final TriFunction<A, B, C, NewB> mappingFunctionB;
    private BavetAftBridgeBiConstraintStream<Solution_, NewA, NewB> aftStream;

    public BavetBiMapTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, TriFunction<A, B, C, NewA> mappingFunctionA, TriFunction<A, B, C, NewB> mappingFunctionB) {
        super(constraintFactory, parent);
        this.mappingFunctionA = mappingFunctionA;
        this.mappingFunctionB = mappingFunctionB;
    }

    public void setAftBridge(BavetAftBridgeBiConstraintStream<Solution_, NewA, NewB> aftStream) {
        this.aftStream = aftStream;
    }

    @Override
    public boolean guaranteesDistinct() {
        return false;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        this.assertEmptyChildStreamList();
        int inputStoreIndex = buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this.aftStream);
        MapTriToBiNode<A, B, C, NewA, NewB> node = new MapTriToBiNode<A, B, C, NewA, NewB>(inputStoreIndex, this.mappingFunctionA, this.mappingFunctionB, buildHelper.getAggregatedTupleLifecycle(this.aftStream.getChildStreamList()), outputStoreSize);
        buildHelper.addNode(node, this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BavetBiMapTriConstraintStream that = (BavetBiMapTriConstraintStream)object;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.mappingFunctionA, that.mappingFunctionA) && Objects.equals(this.mappingFunctionB, that.mappingFunctionB);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.mappingFunctionA, this.mappingFunctionB);
    }

    public String toString() {
        return "BiMap()";
    }
}

