/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.uni;

import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractMapNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TriTuple;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.UniTuple;
import java.util.Objects;
import java.util.function.Function;

final class MapUniToTriNode<A, NewA, NewB, NewC>
extends AbstractMapNode<UniTuple<A>, TriTuple<NewA, NewB, NewC>> {
    private final Function<A, NewA> mappingFunctionA;
    private final Function<A, NewB> mappingFunctionB;
    private final Function<A, NewC> mappingFunctionC;

    MapUniToTriNode(int mapStoreIndex, Function<A, NewA> mappingFunctionA, Function<A, NewB> mappingFunctionB, Function<A, NewC> mappingFunctionC, TupleLifecycle<TriTuple<NewA, NewB, NewC>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
        this.mappingFunctionC = Objects.requireNonNull(mappingFunctionC);
    }

    @Override
    protected TriTuple<NewA, NewB, NewC> map(UniTuple<A> tuple) {
        Object factA = tuple.factA;
        return new TriTuple<NewA, NewB, NewC>(this.mappingFunctionA.apply(factA), this.mappingFunctionB.apply(factA), this.mappingFunctionC.apply(factA), this.outputStoreSize);
    }

    @Override
    protected void remap(UniTuple<A> inTuple, TriTuple<NewA, NewB, NewC> outTuple) {
        Object factA = inTuple.factA;
        NewA newA = this.mappingFunctionA.apply(factA);
        NewB newB = this.mappingFunctionB.apply(factA);
        NewC newC = this.mappingFunctionC.apply(factA);
        outTuple.factA = newA;
        outTuple.factB = newB;
        outTuple.factC = newC;
    }
}

