/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.bi;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.impl.util.Pair;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

final class ComposeTwoBiCollector<A, B, ResultHolder1_, ResultHolder2_, Result1_, Result2_, Result_>
implements BiConstraintCollector<A, B, Pair<ResultHolder1_, ResultHolder2_>, Result_> {
    private final BiConstraintCollector<A, B, ResultHolder1_, Result1_> first;
    private final BiConstraintCollector<A, B, ResultHolder2_, Result2_> second;
    private final BiFunction<Result1_, Result2_, Result_> composeFunction;
    private final Supplier<ResultHolder1_> firstSupplier;
    private final Supplier<ResultHolder2_> secondSupplier;
    private final TriFunction<ResultHolder1_, A, B, Runnable> firstAccumulator;
    private final TriFunction<ResultHolder2_, A, B, Runnable> secondAccumulator;
    private final Function<ResultHolder1_, Result1_> firstFinisher;
    private final Function<ResultHolder2_, Result2_> secondFinisher;

    ComposeTwoBiCollector(BiConstraintCollector<A, B, ResultHolder1_, Result1_> first, BiConstraintCollector<A, B, ResultHolder2_, Result2_> second, BiFunction<Result1_, Result2_, Result_> composeFunction) {
        this.first = first;
        this.second = second;
        this.composeFunction = composeFunction;
        this.firstSupplier = first.supplier();
        this.secondSupplier = second.supplier();
        this.firstAccumulator = first.accumulator();
        this.secondAccumulator = second.accumulator();
        this.firstFinisher = first.finisher();
        this.secondFinisher = second.finisher();
    }

    @Override
    public Supplier<Pair<ResultHolder1_, ResultHolder2_>> supplier() {
        return () -> new Pair<ResultHolder1_, ResultHolder2_>(this.firstSupplier.get(), this.secondSupplier.get());
    }

    @Override
    public TriFunction<Pair<ResultHolder1_, ResultHolder2_>, A, B, Runnable> accumulator() {
        return (resultHolder, a, b) -> ComposeTwoBiCollector.composeUndo(this.firstAccumulator.apply(resultHolder.key(), a, b), this.secondAccumulator.apply(resultHolder.value(), a, b));
    }

    private static Runnable composeUndo(Runnable first, Runnable second) {
        return () -> {
            first.run();
            second.run();
        };
    }

    @Override
    public Function<Pair<ResultHolder1_, ResultHolder2_>, Result_> finisher() {
        return resultHolder -> this.composeFunction.apply(this.firstFinisher.apply(resultHolder.key()), this.secondFinisher.apply(resultHolder.value()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ComposeTwoBiCollector that = (ComposeTwoBiCollector)object;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second) && Objects.equals(this.composeFunction, that.composeFunction);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.composeFunction);
    }
}

