/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.bi;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;

final class ConditionalBiCollector<A, B, ResultContainer_, Result_>
implements BiConstraintCollector<A, B, ResultContainer_, Result_> {
    private final BiPredicate<A, B> predicate;
    private final BiConstraintCollector<A, B, ResultContainer_, Result_> delegate;
    private final TriFunction<ResultContainer_, A, B, Runnable> innerAccumulator;

    ConditionalBiCollector(BiPredicate<A, B> predicate, BiConstraintCollector<A, B, ResultContainer_, Result_> delegate) {
        this.predicate = predicate;
        this.delegate = delegate;
        this.innerAccumulator = delegate.accumulator();
    }

    @Override
    public Supplier<ResultContainer_> supplier() {
        return this.delegate.supplier();
    }

    @Override
    public TriFunction<ResultContainer_, A, B, Runnable> accumulator() {
        return (resultContainer, a, b) -> {
            if (this.predicate.test(a, b)) {
                return this.innerAccumulator.apply(resultContainer, a, b);
            }
            return ConstantLambdaUtils.noop();
        };
    }

    @Override
    public Function<ResultContainer_, Result_> finisher() {
        return this.delegate.finisher();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConditionalBiCollector that = (ConditionalBiCollector)object;
        return Objects.equals(this.predicate, that.predicate) && Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.predicate, this.delegate);
    }
}

