/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.bi;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.LongCalculator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToLongBiFunction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class LongCalculatorBiCollector<A, B, Output_, Calculator_ extends LongCalculator<Output_>>
implements BiConstraintCollector<A, B, Calculator_, Output_> {
    private final ToLongBiFunction<? super A, ? super B> mapper;

    public LongCalculatorBiCollector(ToLongBiFunction<? super A, ? super B> mapper) {
        this.mapper = mapper;
    }

    @Override
    public TriFunction<Calculator_, A, B, Runnable> accumulator() {
        return (calculator, a, b) -> {
            long mapped = this.mapper.applyAsLong(a, b);
            calculator.insert(mapped);
            return () -> calculator.retract(mapped);
        };
    }

    @Override
    public Function<Calculator_, Output_> finisher() {
        return LongCalculator::result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LongCalculatorBiCollector that = (LongCalculatorBiCollector)object;
        return Objects.equals(this.mapper, that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

