/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.bi;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.UndoableActionable;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class UndoableActionableBiCollector<A, B, Input_, Output_, Calculator_ extends UndoableActionable<Input_, Output_>>
implements BiConstraintCollector<A, B, Calculator_, Output_> {
    private final BiFunction<? super A, ? super B, ? extends Input_> mapper;

    public UndoableActionableBiCollector(BiFunction<? super A, ? super B, ? extends Input_> mapper) {
        this.mapper = mapper;
    }

    @Override
    public TriFunction<Calculator_, A, B, Runnable> accumulator() {
        return (calculator, a, b) -> {
            Input_ mapped = this.mapper.apply(a, b);
            return calculator.insert(mapped);
        };
    }

    @Override
    public Function<Calculator_, Output_> finisher() {
        return UndoableActionable::result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UndoableActionableBiCollector that = (UndoableActionableBiCollector)object;
        return Objects.equals(this.mapper, that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

