/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.connected_ranges;

import ai.timefold.solver.core.api.score.stream.common.ConnectedRange;
import ai.timefold.solver.core.api.score.stream.common.ConnectedRangeChain;
import ai.timefold.solver.core.api.score.stream.common.RangeGap;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.ConnectedRangeImpl;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.ConnectedSubrangeIterator;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.Range;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.RangeGapImpl;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.RangeSplitPoint;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiFunction;

public final class ConnectedRangeChainImpl<Range_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>>
implements ConnectedRangeChain<Range_, Point_, Difference_> {
    private final NavigableMap<RangeSplitPoint<Range_, Point_>, ConnectedRangeImpl<Range_, Point_, Difference_>> startSplitPointToConnectedRange = new TreeMap<RangeSplitPoint<Range_, Point_>, ConnectedRangeImpl<Range_, Point_, Difference_>>();
    private final NavigableSet<RangeSplitPoint<Range_, Point_>> splitPointSet;
    private final NavigableMap<RangeSplitPoint<Range_, Point_>, RangeGapImpl<Range_, Point_, Difference_>> startSplitPointToNextGap = new TreeMap<RangeSplitPoint<Range_, Point_>, RangeGapImpl<Range_, Point_, Difference_>>();
    private final BiFunction<? super Point_, ? super Point_, ? extends Difference_> differenceFunction;

    public ConnectedRangeChainImpl(NavigableSet<RangeSplitPoint<Range_, Point_>> splitPointSet, BiFunction<? super Point_, ? super Point_, ? extends Difference_> differenceFunction) {
        this.splitPointSet = splitPointSet;
        this.differenceFunction = differenceFunction;
    }

    void addRange(Range<Range_, Point_> range) {
        NavigableMap<RangeSplitPoint<Range_, Point_>, ConnectedRangeImpl<Range_, Point_, Difference_>> intersectedConnectedRangeMap = this.startSplitPointToConnectedRange.subMap(Objects.requireNonNullElseGet(this.startSplitPointToConnectedRange.floorKey(range.getStartSplitPoint()), range::getStartSplitPoint), true, range.getEndSplitPoint(), true);
        if (!intersectedConnectedRangeMap.isEmpty() && intersectedConnectedRangeMap.firstEntry().getValue().getEndSplitPoint().isBefore(range.getStartSplitPoint())) {
            intersectedConnectedRangeMap = intersectedConnectedRangeMap.subMap((RangeSplitPoint)intersectedConnectedRangeMap.firstKey(), false, (RangeSplitPoint)intersectedConnectedRangeMap.lastKey(), true);
        }
        if (intersectedConnectedRangeMap.isEmpty()) {
            this.createNewConnectedRange(range);
            return;
        }
        ConnectedRangeImpl<Range_, Point_, Difference_> firstIntersectedConnectedRange = intersectedConnectedRangeMap.firstEntry().getValue();
        RangeSplitPoint<Range_, Point_> oldStartSplitPoint = firstIntersectedConnectedRange.getStartSplitPoint();
        firstIntersectedConnectedRange.addRange(range);
        intersectedConnectedRangeMap.tailMap(oldStartSplitPoint, false).values().forEach(firstIntersectedConnectedRange::mergeConnectedRange);
        intersectedConnectedRangeMap.tailMap(oldStartSplitPoint, false).clear();
        this.removeSpannedGapsAndUpdateIntersectedGaps(range, firstIntersectedConnectedRange);
        if (oldStartSplitPoint.isAfter(firstIntersectedConnectedRange.getStartSplitPoint())) {
            this.startSplitPointToConnectedRange.remove(oldStartSplitPoint);
            this.startSplitPointToConnectedRange.put(firstIntersectedConnectedRange.getStartSplitPoint(), firstIntersectedConnectedRange);
            RangeGapImpl nextGap = (RangeGapImpl)this.startSplitPointToNextGap.get(firstIntersectedConnectedRange.getStartSplitPoint());
            if (nextGap != null) {
                nextGap.setPreviousConnectedRange(firstIntersectedConnectedRange);
                nextGap.setLength((Comparable)this.differenceFunction.apply(nextGap.getPreviousRangeEnd(), nextGap.getNextRangeStart()));
            }
        }
    }

    private void createNewConnectedRange(Range<Range_, Point_> range) {
        Map.Entry<RangeSplitPoint<Range_, Point_>, ConnectedRangeImpl<Range_, Point_, Difference_>> previousConnectedRangeEntry;
        RangeSplitPoint<Range_, Point_> startSplitPoint = this.splitPointSet.floor(range.getStartSplitPoint());
        ConnectedRangeImpl<Range_, Point_, Difference_> newConnectedRange = ConnectedRangeImpl.getConnectedRangeStartingAt(this.splitPointSet, this.differenceFunction, startSplitPoint);
        this.startSplitPointToConnectedRange.put(startSplitPoint, newConnectedRange);
        Map.Entry<RangeSplitPoint<Range_, Point_>, ConnectedRangeImpl<Range_, Point_, Difference_>> nextConnectedRangeEntry = this.startSplitPointToConnectedRange.higherEntry(startSplitPoint);
        if (nextConnectedRangeEntry != null) {
            ConnectedRangeImpl<Range_, Point_, Difference_> nextConnectedRange = nextConnectedRangeEntry.getValue();
            Comparable difference = (Comparable)this.differenceFunction.apply(newConnectedRange.getEnd(), nextConnectedRange.getStart());
            RangeGapImpl<Range_, ? super Point_, Comparable> newGap = new RangeGapImpl<Range_, Point_, Comparable>(newConnectedRange, nextConnectedRange, difference);
            this.startSplitPointToNextGap.put(startSplitPoint, newGap);
        }
        if ((previousConnectedRangeEntry = this.startSplitPointToConnectedRange.lowerEntry(startSplitPoint)) != null) {
            ConnectedRangeImpl<Range_, Point_, Difference_> previousConnectedRange = previousConnectedRangeEntry.getValue();
            Comparable difference = (Comparable)this.differenceFunction.apply(previousConnectedRange.getEnd(), newConnectedRange.getStart());
            RangeGapImpl<Range_, ? super Point_, Comparable> newGap = new RangeGapImpl<Range_, Point_, Comparable>(previousConnectedRange, newConnectedRange, difference);
            this.startSplitPointToNextGap.put(previousConnectedRangeEntry.getKey(), newGap);
        }
    }

    private void removeSpannedGapsAndUpdateIntersectedGaps(Range<Range_, Point_> range, ConnectedRangeImpl<Range_, Point_, Difference_> connectedRange) {
        RangeSplitPoint firstGapSplitPointBeforeRange = Objects.requireNonNullElseGet(this.startSplitPointToNextGap.floorKey(range.getStartSplitPoint()), range::getStartSplitPoint);
        NavigableMap<RangeSplitPoint<Range_, Point_>, RangeGapImpl<Range_, Point_, Difference_>> intersectedRangeGapMap = this.startSplitPointToNextGap.subMap(firstGapSplitPointBeforeRange, true, range.getEndSplitPoint(), true);
        if (intersectedRangeGapMap.isEmpty()) {
            return;
        }
        ConnectedRangeImpl connectedRangeBeforeFirstIntersectedGap = (ConnectedRangeImpl)intersectedRangeGapMap.firstEntry().getValue().getPreviousConnectedRange();
        ConnectedRangeImpl connectedRangeAfterFinalIntersectedGap = (ConnectedRangeImpl)intersectedRangeGapMap.lastEntry().getValue().getNextConnectedRange();
        if (!range.getStartSplitPoint().isAfter(connectedRangeBeforeFirstIntersectedGap.getEndSplitPoint())) {
            if (!range.getEndSplitPoint().isBefore(connectedRangeAfterFinalIntersectedGap.getStartSplitPoint())) {
                intersectedRangeGapMap.clear();
            } else {
                RangeGapImpl<Range_, Point_, Difference_> finalGap = intersectedRangeGapMap.lastEntry().getValue();
                finalGap.setPreviousConnectedRange(connectedRange);
                finalGap.setLength((Comparable)this.differenceFunction.apply(finalGap.getPreviousRangeEnd(), finalGap.getNextRangeStart()));
                intersectedRangeGapMap.clear();
                this.startSplitPointToNextGap.put(connectedRange.getStartSplitPoint(), finalGap);
            }
        } else if (!range.getEndSplitPoint().isBefore(connectedRangeAfterFinalIntersectedGap.getStartSplitPoint())) {
            Map.Entry<RangeSplitPoint<Range_, Point_>, RangeGapImpl<Range_, Point_, Difference_>> previousGapEntry = intersectedRangeGapMap.firstEntry();
            RangeGapImpl<Range_, Point_, Difference_> previousGap = previousGapEntry.getValue();
            previousGap.setNextConnectedRange(connectedRange);
            previousGap.setLength((Comparable)this.differenceFunction.apply(previousGap.getPreviousRangeEnd(), connectedRange.getStart()));
            intersectedRangeGapMap.clear();
            this.startSplitPointToNextGap.put(((ConnectedRangeImpl)previousGap.getPreviousConnectedRange()).getStartSplitPoint(), previousGap);
        } else {
            RangeGapImpl<Range_, Point_, Comparable> finalGap = intersectedRangeGapMap.lastEntry().getValue();
            finalGap.setLength((Comparable)this.differenceFunction.apply(finalGap.getPreviousRangeEnd(), finalGap.getNextRangeStart()));
            Map.Entry<RangeSplitPoint<Range_, Point_>, RangeGapImpl<Range_, Point_, Difference_>> previousGapEntry = intersectedRangeGapMap.firstEntry();
            RangeGapImpl<Range_, Point_, Difference_> previousGap = previousGapEntry.getValue();
            previousGap.setNextConnectedRange(connectedRange);
            previousGap.setLength((Comparable)this.differenceFunction.apply(previousGap.getPreviousRangeEnd(), connectedRange.getStart()));
            intersectedRangeGapMap.clear();
            this.startSplitPointToNextGap.put(previousGapEntry.getKey(), previousGap);
            this.startSplitPointToNextGap.put(connectedRange.getStartSplitPoint(), finalGap);
        }
    }

    void removeRange(Range<Range_, Point_> range) {
        Map.Entry<RangeSplitPoint<Range_, Point_>, ConnectedRangeImpl<Range_, Point_, Difference_>> connectedRangeEntry = this.startSplitPointToConnectedRange.floorEntry(range.getStartSplitPoint());
        ConnectedRangeImpl<Range_, Point_, Difference_> connectedRange = connectedRangeEntry.getValue();
        this.startSplitPointToConnectedRange.remove(connectedRangeEntry.getKey());
        Map.Entry<RangeSplitPoint<Range_, Point_>, RangeGapImpl<Range_, Point_, Difference_>> previousGapEntry = this.startSplitPointToNextGap.lowerEntry(connectedRangeEntry.getKey());
        Map.Entry<RangeSplitPoint<Range_, Point_>, ConnectedRangeImpl<Range_, Point_, Difference_>> nextConnectedRangeEntry = this.startSplitPointToConnectedRange.higherEntry(connectedRangeEntry.getKey());
        this.startSplitPointToNextGap.remove(connectedRangeEntry.getKey());
        RangeGapImpl<Range_, Point_, Object> previousGap = previousGapEntry != null ? previousGapEntry.getValue() : null;
        Object previousConnectedRange = previousGap != null ? (ConnectedRangeImpl)previousGap.getPreviousConnectedRange() : null;
        ConnectedSubrangeIterator<Range_, Point_, Difference_> iterator = new ConnectedSubrangeIterator<Range_, Point_, Difference_>(this.splitPointSet, connectedRange.getStartSplitPoint(), connectedRange.getEndSplitPoint(), this.differenceFunction);
        while (iterator.hasNext()) {
            Object newConnectedRange = iterator.next();
            if (previousGap != null) {
                previousGap.setNextConnectedRange((ConnectedRange<Range_, Point_, Object>)newConnectedRange);
                previousGap.setLength((Comparable)this.differenceFunction.apply(previousGap.getPreviousConnectedRange().getEnd(), ((ConnectedRangeImpl)newConnectedRange).getStart()));
                this.startSplitPointToNextGap.put(((ConnectedRangeImpl)previousGap.getPreviousConnectedRange()).getStartSplitPoint(), previousGap);
            }
            previousGap = new RangeGapImpl(newConnectedRange, null, null);
            previousConnectedRange = newConnectedRange;
            this.startSplitPointToConnectedRange.put(((ConnectedRangeImpl)newConnectedRange).getStartSplitPoint(), (ConnectedRangeImpl<Range_, Point_, Difference_>)newConnectedRange);
        }
        if (nextConnectedRangeEntry != null && previousGap != null) {
            previousGap.setNextConnectedRange((ConnectedRange)nextConnectedRangeEntry.getValue());
            previousGap.setLength((Comparable)this.differenceFunction.apply(((ConnectedRangeImpl)previousConnectedRange).getEnd(), nextConnectedRangeEntry.getValue().getStart()));
            this.startSplitPointToNextGap.put(((ConnectedRangeImpl)previousConnectedRange).getStartSplitPoint(), previousGap);
        } else if (previousGapEntry != null && previousGap == previousGapEntry.getValue()) {
            this.startSplitPointToNextGap.remove(previousGapEntry.getKey());
        }
    }

    @Override
    public Iterable<ConnectedRange<Range_, Point_, Difference_>> getConnectedRanges() {
        return this.startSplitPointToConnectedRange.values();
    }

    @Override
    public Iterable<RangeGap<Point_, Difference_>> getGaps() {
        return this.startSplitPointToNextGap.values();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectedRangeChainImpl)) {
            return false;
        }
        ConnectedRangeChainImpl that = (ConnectedRangeChainImpl)o;
        return Objects.equals(this.startSplitPointToConnectedRange, that.startSplitPointToConnectedRange) && Objects.equals(this.splitPointSet, that.splitPointSet) && Objects.equals(this.startSplitPointToNextGap, that.startSplitPointToNextGap);
    }

    public int hashCode() {
        return Objects.hash(this.startSplitPointToConnectedRange, this.splitPointSet, this.startSplitPointToNextGap);
    }

    public String toString() {
        return "ConnectedRangeChain {connectedRanges=" + this.getConnectedRanges() + ", gaps=" + this.getGaps() + "}";
    }
}

