/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.connected_ranges;

import ai.timefold.solver.core.api.score.stream.common.ConnectedRange;
import ai.timefold.solver.core.api.score.stream.common.RangeGap;
import java.util.Objects;

final class RangeGapImpl<Range_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>>
implements RangeGap<Point_, Difference_> {
    private ConnectedRange<Range_, Point_, Difference_> previousConnectedRange;
    private ConnectedRange<Range_, Point_, Difference_> nextConnectedRange;
    private Difference_ length;

    RangeGapImpl(ConnectedRange<Range_, Point_, Difference_> previousConnectedRange, ConnectedRange<Range_, Point_, Difference_> nextConnectedRange, Difference_ length) {
        this.previousConnectedRange = previousConnectedRange;
        this.nextConnectedRange = nextConnectedRange;
        this.length = length;
    }

    ConnectedRange<Range_, Point_, Difference_> getPreviousConnectedRange() {
        return this.previousConnectedRange;
    }

    ConnectedRange<Range_, Point_, Difference_> getNextConnectedRange() {
        return this.nextConnectedRange;
    }

    @Override
    public Point_ getPreviousRangeEnd() {
        return this.previousConnectedRange.getEnd();
    }

    @Override
    public Point_ getNextRangeStart() {
        return this.nextConnectedRange.getStart();
    }

    @Override
    public Difference_ getLength() {
        return this.length;
    }

    void setPreviousConnectedRange(ConnectedRange<Range_, Point_, Difference_> previousConnectedRange) {
        this.previousConnectedRange = previousConnectedRange;
    }

    void setNextConnectedRange(ConnectedRange<Range_, Point_, Difference_> nextConnectedRange) {
        this.nextConnectedRange = nextConnectedRange;
    }

    void setLength(Difference_ length) {
        this.length = length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeGapImpl)) {
            return false;
        }
        RangeGapImpl rangeGap = (RangeGapImpl)o;
        return Objects.equals(this.getPreviousRangeEnd(), rangeGap.getPreviousRangeEnd()) && Objects.equals(this.getNextRangeStart(), rangeGap.getNextRangeStart());
    }

    public int hashCode() {
        return Objects.hash(this.getPreviousRangeEnd(), this.getNextRangeStart());
    }

    public String toString() {
        return "RangeGap{start=" + this.getPreviousRangeEnd() + ", end=" + this.getNextRangeStart() + ", length=" + this.length + "}";
    }
}

