/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.consecutive;

import ai.timefold.solver.core.api.score.stream.common.Break;
import ai.timefold.solver.core.api.score.stream.common.Sequence;
import ai.timefold.solver.core.impl.score.stream.collector.consecutive.ComparableValue;
import ai.timefold.solver.core.impl.score.stream.collector.consecutive.ConsecutiveSetTree;
import java.util.Collection;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.stream.Collectors;

final class SequenceImpl<Value_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>>
implements Sequence<Value_, Difference_> {
    private final ConsecutiveSetTree<Value_, Point_, Difference_> sourceTree;
    ComparableValue<Value_, Point_> firstItem;
    ComparableValue<Value_, Point_> lastItem;
    private Difference_ length;
    private NavigableMap<ComparableValue<Value_, Point_>, Value_> comparableItems;
    private Collection<Value_> items;

    SequenceImpl(ConsecutiveSetTree<Value_, Point_, Difference_> sourceTree, ComparableValue<Value_, Point_> item) {
        this(sourceTree, item, item);
    }

    SequenceImpl(ConsecutiveSetTree<Value_, Point_, Difference_> sourceTree, ComparableValue<Value_, Point_> firstItem, ComparableValue<Value_, Point_> lastItem) {
        this.sourceTree = sourceTree;
        this.firstItem = firstItem;
        this.lastItem = lastItem;
        this.length = null;
        this.comparableItems = null;
        this.items = null;
    }

    @Override
    public Value_ getFirstItem() {
        return this.firstItem.value();
    }

    @Override
    public Value_ getLastItem() {
        return this.lastItem.value();
    }

    @Override
    public Break<Value_, Difference_> getPreviousBreak() {
        return this.sourceTree.getBreakBefore(this.firstItem);
    }

    @Override
    public Break<Value_, Difference_> getNextBreak() {
        return this.sourceTree.getBreakAfter(this.lastItem);
    }

    @Override
    public boolean isFirst() {
        return this.firstItem == this.sourceTree.getFirstItem();
    }

    @Override
    public boolean isLast() {
        return this.lastItem == this.sourceTree.getLastItem();
    }

    @Override
    public Collection<Value_> getItems() {
        if (this.items == null) {
            this.items = this.getComparableItems().values();
            return this.items;
        }
        return Collections.unmodifiableCollection(this.items);
    }

    NavigableMap<ComparableValue<Value_, Point_>, Value_> getComparableItems() {
        if (this.comparableItems == null) {
            this.comparableItems = this.sourceTree.getComparableItems(this.firstItem, this.lastItem);
            return this.comparableItems;
        }
        return this.comparableItems;
    }

    @Override
    public int getCount() {
        return this.getComparableItems().size();
    }

    @Override
    public Difference_ getLength() {
        if (this.length == null) {
            this.length = (Comparable)this.sourceTree.sequenceLengthFunction.apply(this.firstItem.index(), this.lastItem.index());
            return this.length;
        }
        return this.length;
    }

    Difference_ computeDifference(SequenceImpl<Value_, Point_, Difference_> to) {
        return (Difference_)((Comparable)this.sourceTree.differenceFunction.apply(this.lastItem.index(), to.firstItem.index()));
    }

    void setStart(ComparableValue<Value_, Point_> item) {
        this.firstItem = item;
        this.invalidate();
    }

    void setEnd(ComparableValue<Value_, Point_> item) {
        this.lastItem = item;
        this.invalidate();
    }

    void invalidate() {
        this.length = null;
        this.comparableItems = null;
        this.items = null;
    }

    SequenceImpl<Value_, Point_, Difference_> split(ComparableValue<Value_, Point_> fromElement) {
        NavigableMap<ComparableValue<Value_, Point_>, Value_> itemSet = this.getComparableItems();
        ComparableValue<Value_, Point_> newSequenceStart = itemSet.higherKey(fromElement);
        ComparableValue<Value_, Point_> newSequenceEnd = this.lastItem;
        this.setEnd(itemSet.lowerKey(fromElement));
        return new SequenceImpl<Value_, Point_, Difference_>(this.sourceTree, newSequenceStart, newSequenceEnd);
    }

    void merge(SequenceImpl<Value_, Point_, Difference_> other) {
        this.lastItem = other.lastItem;
        this.invalidate();
    }

    public String toString() {
        return this.getItems().stream().map(Object::toString).collect(Collectors.joining(", ", "Sequence [", "]"));
    }
}

