/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.quad;

import ai.timefold.solver.core.api.function.PentaFunction;
import ai.timefold.solver.core.api.function.QuadPredicate;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintCollector;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

final class ConditionalQuadCollector<A, B, C, D, ResultContainer_, Result_>
implements QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> {
    private final QuadPredicate<A, B, C, D> predicate;
    private final QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> delegate;
    private final PentaFunction<ResultContainer_, A, B, C, D, Runnable> innerAccumulator;

    ConditionalQuadCollector(QuadPredicate<A, B, C, D> predicate, QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> delegate) {
        this.predicate = predicate;
        this.delegate = delegate;
        this.innerAccumulator = delegate.accumulator();
    }

    @Override
    public Supplier<ResultContainer_> supplier() {
        return this.delegate.supplier();
    }

    @Override
    public PentaFunction<ResultContainer_, A, B, C, D, Runnable> accumulator() {
        return (resultContainer, a, b, c, d) -> {
            if (this.predicate.test(a, b, c, d)) {
                return this.innerAccumulator.apply(resultContainer, a, b, c, d);
            }
            return ConstantLambdaUtils.noop();
        };
    }

    @Override
    public Function<ResultContainer_, Result_> finisher() {
        return this.delegate.finisher();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConditionalQuadCollector that = (ConditionalQuadCollector)object;
        return Objects.equals(this.predicate, that.predicate) && Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.predicate, this.delegate);
    }
}

