/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.quad;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.impl.score.stream.collector.MapUndoableActionable;
import ai.timefold.solver.core.impl.score.stream.collector.quad.UndoableActionableQuadCollector;
import ai.timefold.solver.core.impl.util.Pair;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Supplier;

final class ToMultiMapQuadCollector<A, B, C, D, Key_, Value_, Set_ extends Set<Value_>, Result_ extends Map<Key_, Set_>>
extends UndoableActionableQuadCollector<A, B, C, D, Pair<Key_, Value_>, Result_, MapUndoableActionable<Key_, Value_, Set_, Result_>> {
    private final QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key_> keyFunction;
    private final QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value_> valueFunction;
    private final Supplier<Result_> mapSupplier;
    private final IntFunction<Set_> setFunction;

    ToMultiMapQuadCollector(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key_> keyFunction, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value_> valueFunction, Supplier<Result_> mapSupplier, IntFunction<Set_> setFunction) {
        super((a, b, c, d) -> new Pair(keyFunction.apply(a, b, c, d), valueFunction.apply(a, b, c, d)));
        this.keyFunction = keyFunction;
        this.valueFunction = valueFunction;
        this.mapSupplier = mapSupplier;
        this.setFunction = setFunction;
    }

    @Override
    public Supplier<MapUndoableActionable<Key_, Value_, Set_, Result_>> supplier() {
        return () -> MapUndoableActionable.multiMap(this.mapSupplier, this.setFunction);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ToMultiMapQuadCollector that = (ToMultiMapQuadCollector)object;
        return Objects.equals(this.keyFunction, that.keyFunction) && Objects.equals(this.valueFunction, that.valueFunction) && Objects.equals(this.mapSupplier, that.mapSupplier) && Objects.equals(this.setFunction, that.setFunction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyFunction, this.valueFunction, this.mapSupplier, this.setFunction);
    }
}

