/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.tri;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.TriPredicate;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintCollector;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

final class ConditionalTriCollector<A, B, C, ResultContainer_, Result_>
implements TriConstraintCollector<A, B, C, ResultContainer_, Result_> {
    private final TriPredicate<A, B, C> predicate;
    private final TriConstraintCollector<A, B, C, ResultContainer_, Result_> delegate;
    private final QuadFunction<ResultContainer_, A, B, C, Runnable> innerAccumulator;

    ConditionalTriCollector(TriPredicate<A, B, C> predicate, TriConstraintCollector<A, B, C, ResultContainer_, Result_> delegate) {
        this.predicate = predicate;
        this.delegate = delegate;
        this.innerAccumulator = delegate.accumulator();
    }

    @Override
    public Supplier<ResultContainer_> supplier() {
        return this.delegate.supplier();
    }

    @Override
    public QuadFunction<ResultContainer_, A, B, C, Runnable> accumulator() {
        return (resultContainer, a, b, c) -> {
            if (this.predicate.test(a, b, c)) {
                return this.innerAccumulator.apply(resultContainer, a, b, c);
            }
            return ConstantLambdaUtils.noop();
        };
    }

    @Override
    public Function<ResultContainer_, Result_> finisher() {
        return this.delegate.finisher();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConditionalTriCollector that = (ConditionalTriCollector)object;
        return Objects.equals(this.predicate, that.predicate) && Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.predicate, this.delegate);
    }
}

