/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.tri;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.ObjectCalculator;
import java.util.Objects;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ObjectCalculatorTriCollector<A, B, C, Input_, Output_, Mapped_, Calculator_ extends ObjectCalculator<Input_, Output_, Mapped_>>
implements TriConstraintCollector<A, B, C, Calculator_, Output_> {
    protected final TriFunction<? super A, ? super B, ? super C, ? extends Input_> mapper;

    public ObjectCalculatorTriCollector(TriFunction<? super A, ? super B, ? super C, ? extends Input_> mapper) {
        this.mapper = mapper;
    }

    @Override
    public QuadFunction<Calculator_, A, B, C, Runnable> accumulator() {
        return (calculator, a, b, c) -> {
            Input_ mapped = this.mapper.apply(a, b, c);
            Object saved = calculator.insert(mapped);
            return () -> calculator.retract(saved);
        };
    }

    @Override
    public Function<Calculator_, Output_> finisher() {
        return ObjectCalculator::result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObjectCalculatorTriCollector that = (ObjectCalculatorTriCollector)object;
        return Objects.equals(this.mapper, that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

