/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.tri;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.impl.score.stream.collector.MapUndoableActionable;
import ai.timefold.solver.core.impl.score.stream.collector.tri.UndoableActionableTriCollector;
import ai.timefold.solver.core.impl.util.Pair;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Supplier;

final class ToMultiMapTriCollector<A, B, C, Key_, Value_, Set_ extends Set<Value_>, Result_ extends Map<Key_, Set_>>
extends UndoableActionableTriCollector<A, B, C, Pair<Key_, Value_>, Result_, MapUndoableActionable<Key_, Value_, Set_, Result_>> {
    private final TriFunction<? super A, ? super B, ? super C, ? extends Key_> keyFunction;
    private final TriFunction<? super A, ? super B, ? super C, ? extends Value_> valueFunction;
    private final Supplier<Result_> mapSupplier;
    private final IntFunction<Set_> setFunction;

    ToMultiMapTriCollector(TriFunction<? super A, ? super B, ? super C, ? extends Key_> keyFunction, TriFunction<? super A, ? super B, ? super C, ? extends Value_> valueFunction, Supplier<Result_> mapSupplier, IntFunction<Set_> setFunction) {
        super((a, b, c) -> new Pair(keyFunction.apply(a, b, c), valueFunction.apply(a, b, c)));
        this.keyFunction = keyFunction;
        this.valueFunction = valueFunction;
        this.mapSupplier = mapSupplier;
        this.setFunction = setFunction;
    }

    @Override
    public Supplier<MapUndoableActionable<Key_, Value_, Set_, Result_>> supplier() {
        return () -> MapUndoableActionable.multiMap(this.mapSupplier, this.setFunction);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ToMultiMapTriCollector that = (ToMultiMapTriCollector)object;
        return Objects.equals(this.keyFunction, that.keyFunction) && Objects.equals(this.valueFunction, that.valueFunction) && Objects.equals(this.mapSupplier, that.mapSupplier) && Objects.equals(this.setFunction, that.setFunction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyFunction, this.valueFunction, this.mapSupplier, this.setFunction);
    }
}

