/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.uni;

import ai.timefold.solver.core.api.score.stream.common.LoadBalance;
import ai.timefold.solver.core.api.score.stream.uni.UniConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.LoadBalanceImpl;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;

final class LoadBalanceUniCollector<A, Balanced_>
implements UniConstraintCollector<A, LoadBalanceImpl<Balanced_>, LoadBalance<Balanced_>> {
    private final Function<A, Balanced_> balancedItemFunction;
    private final ToLongFunction<A> loadFunction;
    private final ToLongFunction<A> initialLoadFunction;

    public LoadBalanceUniCollector(Function<A, Balanced_> balancedItemFunction, ToLongFunction<A> loadFunction, ToLongFunction<A> initialLoadFunction) {
        this.balancedItemFunction = balancedItemFunction;
        this.loadFunction = loadFunction;
        this.initialLoadFunction = initialLoadFunction;
    }

    @Override
    public Supplier<LoadBalanceImpl<Balanced_>> supplier() {
        return LoadBalanceImpl::new;
    }

    @Override
    public BiFunction<LoadBalanceImpl<Balanced_>, A, Runnable> accumulator() {
        return (balanceStatistics, a) -> {
            Balanced_ balanced = this.balancedItemFunction.apply(a);
            long initialLoad = this.initialLoadFunction.applyAsLong(a);
            long load = this.loadFunction.applyAsLong(a);
            return balanceStatistics.registerBalanced(balanced, load, initialLoad);
        };
    }

    @Override
    public Function<LoadBalanceImpl<Balanced_>, LoadBalance<Balanced_>> finisher() {
        return balanceStatistics -> balanceStatistics;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof LoadBalanceUniCollector)) return false;
        LoadBalanceUniCollector that = (LoadBalanceUniCollector)o;
        if (!Objects.equals(this.balancedItemFunction, that.balancedItemFunction)) return false;
        if (!Objects.equals(this.loadFunction, that.loadFunction)) return false;
        if (!Objects.equals(this.initialLoadFunction, that.initialLoadFunction)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.balancedItemFunction, this.loadFunction, this.initialLoadFunction);
    }
}

