/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.inliner;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import ai.timefold.solver.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import ai.timefold.solver.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import ai.timefold.solver.core.api.score.buildin.hardsoft.HardSoftScore;
import ai.timefold.solver.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import ai.timefold.solver.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import ai.timefold.solver.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import ai.timefold.solver.core.api.score.buildin.simplelong.SimpleLongScore;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.impl.score.buildin.BendableBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.BendableLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.BendableScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardMediumSoftBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardMediumSoftLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardMediumSoftScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardSoftBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardSoftLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardSoftScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.SimpleBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.SimpleLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.SimpleScoreDefinition;
import ai.timefold.solver.core.impl.score.constraint.DefaultConstraintMatchTotal;
import ai.timefold.solver.core.impl.score.constraint.DefaultIndictment;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.inliner.BendableBigDecimalScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.BendableLongScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.BendableScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ConstraintMatchSupplier;
import ai.timefold.solver.core.impl.score.stream.common.inliner.HardMediumSoftBigDecimalScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.HardMediumSoftLongScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.HardMediumSoftScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.HardSoftBigDecimalScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.HardSoftLongScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.HardSoftScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.SimpleBigDecimalScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.SimpleLongScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.SimpleScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.impl.score.stream.common.inliner.WeightedScoreImpacter;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;

public abstract class AbstractScoreInliner<Score_ extends Score<Score_>> {
    @Deprecated(forRemoval=true)
    private static final String CUSTOM_SCORE_INLINER_CLASS_PROPERTY_NAME = "ai.timefold.solver.score.stream.inliner";
    protected final boolean constraintMatchEnabled;
    protected final Map<Constraint, Score_> constraintWeightMap;
    private final Map<Constraint, ElementAwareList<ConstraintMatchCarrier<Score_>>> constraintMatchMap;
    private Map<String, ConstraintMatchTotal<Score_>> constraintIdToConstraintMatchTotalMap = null;
    private Map<Object, Indictment<Score_>> indictmentMap = null;

    public static <Score_ extends Score<Score_>, ScoreInliner_ extends AbstractScoreInliner<Score_>> ScoreInliner_ buildScoreInliner(ScoreDefinition<Score_> scoreDefinition, Map<Constraint, Score_> constraintWeightMap, boolean constraintMatchEnabled) {
        if (scoreDefinition instanceof SimpleScoreDefinition) {
            return (ScoreInliner_)new SimpleScoreInliner(constraintWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof SimpleLongScoreDefinition) {
            return (ScoreInliner_)new SimpleLongScoreInliner((Map<Constraint, SimpleLongScore>)constraintWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof SimpleBigDecimalScoreDefinition) {
            return (ScoreInliner_)new SimpleBigDecimalScoreInliner((Map<Constraint, SimpleBigDecimalScore>)constraintWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardSoftScoreDefinition) {
            return (ScoreInliner_)new HardSoftScoreInliner((Map<Constraint, HardSoftScore>)constraintWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardSoftLongScoreDefinition) {
            return (ScoreInliner_)new HardSoftLongScoreInliner((Map<Constraint, HardSoftLongScore>)constraintWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardSoftBigDecimalScoreDefinition) {
            return (ScoreInliner_)new HardSoftBigDecimalScoreInliner((Map<Constraint, HardSoftBigDecimalScore>)constraintWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardMediumSoftScoreDefinition) {
            return (ScoreInliner_)new HardMediumSoftScoreInliner((Map<Constraint, HardMediumSoftScore>)constraintWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardMediumSoftLongScoreDefinition) {
            return (ScoreInliner_)new HardMediumSoftLongScoreInliner((Map<Constraint, HardMediumSoftLongScore>)constraintWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardMediumSoftBigDecimalScoreDefinition) {
            return (ScoreInliner_)new HardMediumSoftBigDecimalScoreInliner((Map<Constraint, HardMediumSoftBigDecimalScore>)constraintWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof BendableScoreDefinition) {
            BendableScoreDefinition bendableScoreDefinition = (BendableScoreDefinition)scoreDefinition;
            return (ScoreInliner_)new BendableScoreInliner(constraintWeightMap, constraintMatchEnabled, bendableScoreDefinition.getHardLevelsSize(), bendableScoreDefinition.getSoftLevelsSize());
        }
        if (scoreDefinition instanceof BendableLongScoreDefinition) {
            BendableLongScoreDefinition bendableScoreDefinition = (BendableLongScoreDefinition)scoreDefinition;
            return (ScoreInliner_)new BendableLongScoreInliner(constraintWeightMap, constraintMatchEnabled, bendableScoreDefinition.getHardLevelsSize(), bendableScoreDefinition.getSoftLevelsSize());
        }
        if (scoreDefinition instanceof BendableBigDecimalScoreDefinition) {
            BendableBigDecimalScoreDefinition bendableScoreDefinition = (BendableBigDecimalScoreDefinition)scoreDefinition;
            return (ScoreInliner_)new BendableBigDecimalScoreInliner(constraintWeightMap, constraintMatchEnabled, bendableScoreDefinition.getHardLevelsSize(), bendableScoreDefinition.getSoftLevelsSize());
        }
        String customScoreInlinerClassName = System.getProperty(CUSTOM_SCORE_INLINER_CLASS_PROPERTY_NAME);
        if (customScoreInlinerClassName == null) {
            throw new UnsupportedOperationException("Unknown score definition class (" + scoreDefinition.getClass().getCanonicalName() + ").\nIf you're attempting to use a custom score, provide your " + AbstractScoreInliner.class.getSimpleName() + " implementation using the 'ai.timefold.solver.score.stream.inliner' system property.\nNote: support for custom scores will be removed in Timefold 2.0.");
        }
        try {
            Class<?> customScoreInlinerClass = Class.forName(customScoreInlinerClassName);
            if (!AbstractScoreInliner.class.isAssignableFrom(customScoreInlinerClass)) {
                throw new IllegalStateException("Custom score inliner class (" + customScoreInlinerClassName + ") does not extend " + AbstractScoreInliner.class.getCanonicalName() + ".\nNote: support for custom scores will be removed in Timefold 2.0.");
            }
            return (ScoreInliner_)((AbstractScoreInliner)customScoreInlinerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException cause) {
            throw new IllegalStateException("Custom score inliner class (" + customScoreInlinerClassName + ") can not be instantiated.\nMaybe add a no-arg public constructor?\nNote: support for custom scores will be removed in Timefold 2.0.", cause);
        }
    }

    protected AbstractScoreInliner(Map<Constraint, Score_> constraintWeightMap, boolean constraintMatchEnabled) {
        this.constraintMatchEnabled = constraintMatchEnabled;
        constraintWeightMap.forEach(this::validateConstraintWeight);
        this.constraintWeightMap = constraintWeightMap;
        Map<Object, Object> map = this.constraintMatchMap = constraintMatchEnabled ? CollectionUtils.newIdentityHashMap(constraintWeightMap.size()) : null;
        if (constraintMatchEnabled) {
            for (Constraint constraint : constraintWeightMap.keySet()) {
                this.constraintMatchMap.put(constraint, new ElementAwareList());
            }
        }
    }

    private void validateConstraintWeight(Constraint constraint, Score_ constraintWeight) {
        if (constraintWeight == null || constraintWeight.isZero()) {
            throw new IllegalArgumentException("Impossible state: The constraintWeight (" + constraintWeight + ") cannot be zero, constraint (" + constraint + ") should have been culled during session creation.");
        }
    }

    public abstract Score_ extractScore(int var1);

    public abstract WeightedScoreImpacter<Score_, ?> buildWeightedScoreImpacter(AbstractConstraint<?, ?, ?> var1);

    protected final UndoScoreImpacter addConstraintMatch(Constraint constraint, Score_ score, ConstraintMatchSupplier<Score_> constraintMatchSupplier, UndoScoreImpacter undoScoreImpact) {
        ElementAwareList<ConstraintMatchCarrier<Score_>> constraintMatchList = this.getConstraintMatchList(constraint);
        ElementAwareListEntry<ConstraintMatchCarrier<Score_>> entry = constraintMatchList.add(new ConstraintMatchCarrier<Score_>(constraintMatchSupplier, constraint, score));
        this.clearMaps();
        return () -> {
            undoScoreImpact.run();
            entry.remove();
            this.clearMaps();
        };
    }

    private ElementAwareList<ConstraintMatchCarrier<Score_>> getConstraintMatchList(Constraint constraint) {
        ElementAwareList<ConstraintMatchCarrier<Score_>> constraintMatchList = this.constraintMatchMap.get(constraint);
        if (constraintMatchList == null) {
            throw new IllegalStateException("Impossible state: Unknown constraint (%s).".formatted(constraint.getConstraintRef()));
        }
        return constraintMatchList;
    }

    private void clearMaps() {
        this.constraintIdToConstraintMatchTotalMap = null;
        this.indictmentMap = null;
    }

    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabled;
    }

    public final Map<String, ConstraintMatchTotal<Score_>> getConstraintIdToConstraintMatchTotalMap() {
        if (this.constraintIdToConstraintMatchTotalMap == null) {
            this.rebuildConstraintMatchTotals();
        }
        return this.constraintIdToConstraintMatchTotalMap;
    }

    private void rebuildConstraintMatchTotals() {
        TreeMap<String, ConstraintMatchTotal<Score_>> constraintIdToConstraintMatchTotalMap = new TreeMap<String, ConstraintMatchTotal<Score_>>();
        for (Map.Entry<Constraint, ElementAwareList<ConstraintMatchCarrier<Score_>>> entry : this.constraintMatchMap.entrySet()) {
            Constraint constraint = entry.getKey();
            DefaultConstraintMatchTotal<Score> constraintMatchTotal = new DefaultConstraintMatchTotal<Score>(constraint.getConstraintRef(), (Score)this.constraintWeightMap.get(constraint));
            for (ConstraintMatchCarrier<Score_> carrier : entry.getValue()) {
                Object constraintMatch = carrier.get();
                constraintMatchTotal.addConstraintMatch((ConstraintMatch<Score>)constraintMatch);
            }
            constraintIdToConstraintMatchTotalMap.put(constraint.getConstraintRef().constraintId(), constraintMatchTotal);
        }
        this.constraintIdToConstraintMatchTotalMap = constraintIdToConstraintMatchTotalMap;
    }

    public final Map<Object, Indictment<Score_>> getIndictmentMap() {
        if (this.indictmentMap == null) {
            this.rebuildIndictments();
        }
        return this.indictmentMap;
    }

    private void rebuildIndictments() {
        LinkedHashMap<Object, Indictment<Score_>> workingIndictmentMap = new LinkedHashMap<Object, Indictment<Score_>>();
        for (Map.Entry<Constraint, ElementAwareList<ConstraintMatchCarrier<Score_>>> entry : this.constraintMatchMap.entrySet()) {
            for (ConstraintMatchCarrier<Score_> carrier : entry.getValue()) {
                Object constraintMatch = carrier.get();
                for (Object indictedObject : ((ConstraintMatch)constraintMatch).getIndictedObjectList()) {
                    if (indictedObject == null) continue;
                    DefaultIndictment<Score_> indictment = this.getIndictment((Map<Object, Indictment<Score_>>)workingIndictmentMap, (ConstraintMatch<Score_>)constraintMatch, indictedObject);
                    indictment.addConstraintMatchWithoutFail((ConstraintMatch<Score_>)constraintMatch);
                }
            }
        }
        this.indictmentMap = workingIndictmentMap;
    }

    private DefaultIndictment<Score_> getIndictment(Map<Object, Indictment<Score_>> indictmentMap, ConstraintMatch<Score_> constraintMatch, Object indictedObject) {
        DefaultIndictment indictment = (DefaultIndictment)indictmentMap.get(indictedObject);
        if (indictment == null) {
            indictment = new DefaultIndictment(indictedObject, constraintMatch.getScore().zero());
            indictmentMap.put(indictedObject, indictment);
        }
        return indictment;
    }

    private static final class ConstraintMatchCarrier<Score_ extends Score<Score_>>
    implements Supplier<ConstraintMatch<Score_>> {
        private final Constraint constraint;
        private final ConstraintMatchSupplier<Score_> constraintMatchSupplier;
        private final Score_ score;
        private ConstraintMatch<Score_> constraintMatch;

        private ConstraintMatchCarrier(ConstraintMatchSupplier<Score_> constraintMatchSupplier, Constraint constraint, Score_ score) {
            this.constraint = constraint;
            this.constraintMatchSupplier = constraintMatchSupplier;
            this.score = score;
        }

        @Override
        public ConstraintMatch<Score_> get() {
            if (this.constraintMatch == null) {
                this.constraintMatch = (ConstraintMatch)this.constraintMatchSupplier.apply(this.constraint, this.score);
            }
            return this.constraintMatch;
        }
    }
}

