/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.inliner;

import ai.timefold.solver.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.HardMediumSoftLongScoreContext;
import ai.timefold.solver.core.impl.score.stream.common.inliner.WeightedScoreImpacter;
import java.util.Map;

final class HardMediumSoftLongScoreInliner
extends AbstractScoreInliner<HardMediumSoftLongScore> {
    long hardScore;
    long mediumScore;
    long softScore;

    HardMediumSoftLongScoreInliner(Map<Constraint, HardMediumSoftLongScore> constraintWeightMap, boolean constraintMatchEnabled) {
        super(constraintWeightMap, constraintMatchEnabled);
    }

    @Override
    public WeightedScoreImpacter<HardMediumSoftLongScore, ?> buildWeightedScoreImpacter(AbstractConstraint<?, ?, ?> constraint) {
        HardMediumSoftLongScore constraintWeight = (HardMediumSoftLongScore)this.constraintWeightMap.get(constraint);
        long hardConstraintWeight = constraintWeight.hardScore();
        long mediumConstraintWeight = constraintWeight.mediumScore();
        long softConstraintWeight = constraintWeight.softScore();
        HardMediumSoftLongScoreContext context = new HardMediumSoftLongScoreContext(this, constraint, constraintWeight);
        if (mediumConstraintWeight == 0L && softConstraintWeight == 0L) {
            return WeightedScoreImpacter.of(context, (ctx, matchWeight, constraintMatchSupplier) -> ctx.changeHardScoreBy(matchWeight, constraintMatchSupplier));
        }
        if (hardConstraintWeight == 0L && softConstraintWeight == 0L) {
            return WeightedScoreImpacter.of(context, (ctx, matchWeight, constraintMatchSupplier) -> ctx.changeMediumScoreBy(matchWeight, constraintMatchSupplier));
        }
        if (hardConstraintWeight == 0L && mediumConstraintWeight == 0L) {
            return WeightedScoreImpacter.of(context, (ctx, matchWeight, constraintMatchSupplier) -> ctx.changeSoftScoreBy(matchWeight, constraintMatchSupplier));
        }
        return WeightedScoreImpacter.of(context, (ctx, matchWeight, constraintMatchSupplier) -> ctx.changeScoreBy(matchWeight, constraintMatchSupplier));
    }

    @Override
    public HardMediumSoftLongScore extractScore(int initScore) {
        return HardMediumSoftLongScore.ofUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }

    public String toString() {
        return HardMediumSoftLongScore.class.getSimpleName() + " inliner";
    }
}

